<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:template name="connect-button">
        <xsl:param name="uri-prefix"/>
        <xsl:param name="cssClass">connect</xsl:param>
        <xsl:param name="i18nKey">plugin.nextcloud:PLUGINS_NEXTCLOUD_SERVICE_FOLDER_CONNECT_BUTTON</xsl:param>
        <xsl:call-template name="common-utils-input-submit">
            <xsl:with-param name="class" select="$cssClass"/>
            <xsl:with-param name="i18nkey" select="$i18nKey"/>
            <xsl:with-param name="type">button</xsl:with-param>
            <xsl:with-param name="onclick">
                <xsl:call-template name="connect-action">
                    <xsl:with-param name="uri-prefix" select="$uri-prefix"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="connect-action">
        <xsl:param name="uri-prefix"/>
        window.open('<xsl:value-of select="$uri-prefix"/>/plugins/extra-user-management/oauth/connect/nextcloud', null, 'height: ;')
    </xsl:template>
</xsl:stylesheet>
