/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.OSEExport;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

public abstract class AbstractOSEExport
extends AbstractLogEnabled
implements OSEExport {
    @Override
    public void populate(String ametysCatalog, Long oseCatalog) {
        this._executeQueries(this._populate(ametysCatalog, oseCatalog));
    }

    protected abstract List<ParameterizableQuery> _populate(String var1, Long var2);

    private void _executeQueries(List<ParameterizableQuery> queries) {
        String oseDatasource = (String)Config.getInstance().getValue("ose.datasource");
        try (Connection connection = ConnectionHelper.getConnection((String)oseDatasource);){
            for (ParameterizableQuery query : queries) {
                this._executeQuery(query, connection);
            }
        }
        catch (SQLException e) {
            this.getLogger().error("Error during connection to the database.", (Throwable)e);
        }
    }

    private void _executeQuery(ParameterizableQuery query, Connection connection) {
        try (PreparedStatement stmt = connection.prepareStatement(query.getQuery());){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Will execute {}", (Object)query.toReadableString());
            }
            this._setStatementParameters(stmt, query);
            stmt.execute();
        }
        catch (SQLException e) {
            this.getLogger().error("Impossible to execute the {}", (Object)query.toReadableString(), (Object)e);
        }
    }

    private void _setStatementParameters(PreparedStatement stmt, ParameterizableQuery query) throws SQLException {
        int index = 1;
        for (ValuedQueryParameter parameter : query.getParameters()) {
            stmt.setObject(index, parameter.getValue(), parameter.getType());
            ++index;
        }
    }
}

