/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.List;

import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.impl.odf.db.ElementPedagogiqueHelper;
import org.ametys.odf.program.AbstractProgramPart;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;

/**
 * Exporter of program parts.
 */
public class ProgramPartExporter extends AbstractProgramElementExporter<AbstractProgramPart>
{
    /** Avalon Role */
    public static final String ROLE = ProgramPartExporter.class.getName();
    
    @Override
    protected List<ParameterizableQuery> _getQueries(AbstractProgramPart programElement, ProgramElementData data, Long oseCatalog, CostComputationData costData)
    {
        return ElementPedagogiqueHelper.insertInto(
            programElement.getCode(),
            programElement.getTitle(),
            oseCatalog,
            data.getOrgUnit(),
            data.getStepHolder(),
            data.getPeriodType()
        );
    }
}
