/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.schedulable;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.odf.ose.export.OSEExport;
import org.ametys.odf.ose.export.OSEExportExtensionPoint;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.core.schedule.Scheduler;

/**
 * {@link Schedulable} for OSE export.
 */
public class ExportSchedulable extends AbstractStaticSchedulable
{
    private static final String __AMETYS_CATALOG = "ametys.catalog";
    private static final String __OSE_CATALOG = "ose.catalog";
    private static final String __JOBDATAMAP_AMETYS_CATALOG = Scheduler.PARAM_VALUES_PREFIX + __AMETYS_CATALOG;
    private static final String __JOBDATAMAP_OSE_CATALOG = Scheduler.PARAM_VALUES_PREFIX + __OSE_CATALOG;
    
    /** The OSE export extension point */
    protected OSEExportExtensionPoint _oseExportEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _oseExportEP = (OSEExportExtensionPoint) manager.lookup(OSEExportExtensionPoint.ROLE);
    }
    
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String ametysCatalog = jobDataMap.getString(__JOBDATAMAP_AMETYS_CATALOG);
        Long oseCatalog = jobDataMap.getLong(__JOBDATAMAP_OSE_CATALOG);

        Set<String> exportIds = _oseExportEP.getExtensionsIds();
        
        for (String exportId : exportIds)
        {
            OSEExport export = _oseExportEP.getExtension(exportId);
            export.populate(ametysCatalog, oseCatalog);
        }
    }
}
