/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.enumeration;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.validation.AbstractContentValidator;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.parameter.ValidationResult;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class DegreesInCategoryConsistencyValidator
extends AbstractContentValidator
implements Serviceable {
    private static final String __DEGREES_CATEGORY_CONTENT_TYPE = "odf-enumeration.DegreeCategory";
    private static final String __DEGREES_ATTRIBUTE_NAME = "degrees";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public ValidationResult validate(Content content) {
        return ValidationResult.empty();
    }

    public ValidationResult validate(Content degreeCategory, Map<String, Object> values, View view) {
        ValidationResult result = new ValidationResult();
        Optional.ofNullable(values.get(__DEGREES_ATTRIBUTE_NAME)).map(v -> DataHolderHelper.getValueFromSynchronizableValue((Object)v, (ModelAwareDataHolder)degreeCategory, (ModelItem)degreeCategory.getDefinition(__DEGREES_ATTRIBUTE_NAME), Optional.of(__DEGREES_ATTRIBUTE_NAME), (SynchronizationContext)SynchronizationContext.newInstance())).map(ContentValue[].class::cast).map(Arrays::stream).orElseGet(Stream::empty).map(degree -> degree.getContentIfExists()).flatMap(Optional::stream).filter(degree -> this._isInAnotherCategory((Content)degree, degreeCategory)).map(degree -> this._getErrorLabel((Content)degree, degreeCategory)).forEach(arg_0 -> ((ValidationResult)result).addError(arg_0));
        return result;
    }

    protected boolean _isInAnotherCategory(Content degree, Content degreeCategory) {
        return this._resolver.query(this._getXPathQuery(degree, degreeCategory)).iterator().hasNext();
    }

    protected String _getXPathQuery(Content degree, Content currentDegreeCategory) {
        ContentTypeExpression contentTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{__DEGREES_CATEGORY_CONTENT_TYPE});
        StringExpression categoryExpr = new StringExpression(__DEGREES_ATTRIBUTE_NAME, Expression.Operator.EQ, degree.getId());
        String categoryUUID = StringUtils.substringAfter((String)currentDegreeCategory.getId(), (String)"://");
        Expression notCurrentExpr = () -> "jcr:uuid != '" + categoryUUID + "'";
        AndExpression finalExpression = new AndExpression(new Expression[]{contentTypeExpr, categoryExpr, notCurrentExpr});
        return ContentQueryHelper.getContentXPathQuery((Expression)finalExpression);
    }

    protected I18nizableText _getErrorLabel(Content degree, Content degreeCategory) {
        Map<String, I18nizableText> params = Map.of("degree.title", new I18nizableText(StringUtils.defaultString((String)degree.getTitle())), "degree.code", new I18nizableText(StringUtils.defaultString((String)((String)degree.getDataHolder().getValue("code")))), "degreeCategory.title", new I18nizableText(StringUtils.defaultString((String)degreeCategory.getTitle())), "degreeCategory.code", new I18nizableText(StringUtils.defaultString((String)((String)degreeCategory.getDataHolder().getValue("code")))));
        return new I18nizableText("plugin.odf-ose", "PLUGINS_ODF_OSE_TABLE_REF_DEGREE_CATEGORY_VALIDATOR_UNCONSISTENCY_ERROR", params);
    }
}

