/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.impl.odf.LogUtils;
import org.ametys.odf.ose.export.utils.ElementRetriever;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractProgramElementExporter<T extends Content & ProgramItem>
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected ElementRetriever _elementRetriever;

    public void service(ServiceManager manager) throws ServiceException {
        this._elementRetriever = (ElementRetriever)((Object)manager.lookup(ElementRetriever.ROLE));
    }

    public List<ParameterizableQuery> getQueries(T programElement, Long oseCatalog, CostComputationData costData) {
        Set<OrgUnit> orgUnits = this._elementRetriever.retrieveOrgUnits((ProgramItem)programElement);
        Set<Container> stepsHolder = this._elementRetriever.retrieveStepsHolder((ProgramItem)programElement);
        Set<OdfReferenceTableEntry> periodTypes = this._elementRetriever.retrievePeriodTypes((ProgramItem)programElement);
        if (stepsHolder.size() != 1 || orgUnits.size() != 1) {
            LogUtils.programElementImpossibilityStepsOrOrgunits(this.getLogger(), programElement, stepsHolder, orgUnits);
            return List.of();
        }
        Container stepHolder = this._getFirstStepHolder(stepsHolder);
        Set steps = this._elementRetriever.getSteps((ProgramItem)programElement);
        if (!steps.contains(stepHolder)) {
            LogUtils.programElementDebugIsNotContainedInSteps(this.getLogger(), programElement, stepHolder, steps);
            return List.of();
        }
        ProgramElementData data = new ProgramElementData();
        Optional.of(periodTypes).map(this::_getFirstRefTableCode).ifPresentOrElse(data::setPeriodType, () -> LogUtils.programElementWarningPeriodTypes(this.getLogger(), programElement, periodTypes));
        data.setStepHolder(stepHolder.getCode());
        data.setOrgUnit(this._getFirstOrgUnitCode(orgUnits));
        data.setSteps(steps);
        return this._getQueries(programElement, data, oseCatalog, costData);
    }

    protected abstract List<ParameterizableQuery> _getQueries(T var1, ProgramElementData var2, Long var3, CostComputationData var4);

    private Container _getFirstStepHolder(Set<Container> stepsHolder) {
        return (Container)stepsHolder.stream().findFirst().get();
    }

    private String _getFirstOrgUnitCode(Set<OrgUnit> orgUnits) {
        return orgUnits.stream().findFirst().map(OrgUnit::getUAICode).get();
    }

    private String _getFirstRefTableCode(Set<OdfReferenceTableEntry> entries) {
        return entries.stream().findFirst().map(OdfReferenceTableEntry::getCode).orElse(null);
    }

    protected static class ProgramElementData {
        private String _orgUnitCode;
        private String _stepHolderCode;
        private Set<Container> _steps;
        private String _periodTypeCode;

        protected ProgramElementData() {
        }

        public void setOrgUnit(String orgUnitCode) {
            this._orgUnitCode = orgUnitCode;
        }

        public void setStepHolder(String stepHolderCode) {
            this._stepHolderCode = stepHolderCode;
        }

        public void setPeriodType(String periodTypeCode) {
            this._periodTypeCode = periodTypeCode;
        }

        public void setSteps(Set<Container> steps) {
            this._steps = steps;
        }

        public String getOrgUnit() {
            return this._orgUnitCode;
        }

        public String getStepHolder() {
            return this._stepHolderCode;
        }

        public String getPeriodType() {
            return this._periodTypeCode;
        }

        public Set<Container> getSteps() {
            return this._steps;
        }
    }
}

