/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.impl.odf.LogUtils;
import org.ametys.odf.ose.export.impl.odf.db.EtapeHelper;
import org.ametys.odf.ose.export.utils.ElementRetriever;
import org.ametys.odf.program.Container;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.EmptyIterable;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class StepExporter
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = StepExporter.class.getName();
    protected AmetysObjectResolver _resolver;
    protected ElementRetriever _elementRetriever;
    protected ODFHelper _odfHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._elementRetriever = (ElementRetriever)((Object)manager.lookup(ElementRetriever.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    public AmetysObjectIterable<Container> getStepsToExport(String ametysCatalog) {
        return this._odfHelper.getYearId().map(anneeId -> this._matchingStepsExpression((String)anneeId, ametysCatalog)).map(ContentQueryHelper::getContentXPathQuery).map(arg_0 -> ((AmetysObjectResolver)this._resolver).query(arg_0)).orElseGet(EmptyIterable::new);
    }

    private Expression _matchingStepsExpression(String anneeId, String ametysCatalog) {
        ContentTypeExpression contentTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.odf.Content.container"});
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        LanguageExpression langExpr = new LanguageExpression(Expression.Operator.EQ, lang);
        StringExpression catalogExpr = new StringExpression("catalog", Expression.Operator.EQ, ametysCatalog);
        StringExpression natureExpr = new StringExpression("nature", Expression.Operator.EQ, anneeId);
        NotExpression doExportExpression = new NotExpression((Expression)new BooleanExpression("noOseExport", true));
        return new AndExpression(new Expression[]{contentTypeExpr, langExpr, catalogExpr, natureExpr, doExportExpression});
    }

    public List<ParameterizableQuery> getQueries(Container step, Long oseCatalog) {
        Set<OdfReferenceTableEntry> degrees = this._elementRetriever.retrieveDegree(step);
        Set<OrgUnit> orgUnits = this._elementRetriever.retrieveOrgUnits((ProgramItem)step);
        if (degrees.size() != 1 || orgUnits.size() != 1) {
            LogUtils.stepImpossibilityDegreesOrOrgunits(this.getLogger(), step, degrees, orgUnits);
            return List.of();
        }
        OdfReferenceTableEntry degree = this._getFirstDegree(degrees);
        String degreeCode = degree.getCode();
        String orgUnitCode = this._getFirstOrgUnitCode(orgUnits);
        Optional<String> functionalDomain = this._getFunctionalDomain(degree);
        if (functionalDomain.isEmpty()) {
            LogUtils.stepImpossibilityFunctDomain(this.getLogger(), step);
            return List.of();
        }
        return this._getQueries(step, oseCatalog, degreeCode, orgUnitCode, functionalDomain.get());
    }

    private Optional<String> _getFunctionalDomain(OdfReferenceTableEntry degree) {
        AndExpression expr = new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.DegreeCategory"}), new StringExpression("degrees", Expression.Operator.EQ, degree.getId())});
        String xpathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expr);
        AmetysObjectIterable contents = this._resolver.query(xpathQuery);
        return contents.stream().findFirst().map(c -> (String)c.getValue("functionalDomain"));
    }

    private OdfReferenceTableEntry _getFirstDegree(Set<OdfReferenceTableEntry> degrees) {
        return (OdfReferenceTableEntry)degrees.stream().findFirst().get();
    }

    private String _getFirstOrgUnitCode(Set<OrgUnit> orgUnits) {
        return orgUnits.stream().findFirst().map(OrgUnit::getUAICode).get();
    }

    private List<ParameterizableQuery> _getQueries(Container container, Long oseCatalog, String degree, String orgUnit, String functionalDomain) {
        String apogee;
        Object title = container.getTitle();
        if (ModelHelper.hasModelItem((String)"etpCode", (Collection)container.getModel()) && StringUtils.isNotEmpty((CharSequence)(apogee = (String)container.getValue("etpCode")))) {
            title = (String)title + " (" + apogee + ")";
        }
        String code = container.getCode();
        return EtapeHelper.insertInto(code, (String)title, oseCatalog, degree, orgUnit, functionalDomain);
    }
}

