/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.column.DefaultColumn;
import org.ametys.odf.ose.db.column.ForeignKeyColumn;
import org.ametys.odf.ose.db.column.ScenarioIdColumn;
import org.ametys.odf.ose.db.column.SourceIdColumn;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.StaticQueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.ExportUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class ScenarioLienHelper {
    private static final String __TABLE_NAME = "SCENARIO_LIEN";

    private ScenarioLienHelper() {
    }

    public static List<ParameterizableQuery> initialize() {
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new ForeignKeyColumn("LIEN_ID", "VARCHAR2(100 CHAR)", false, (Pair<String, String>)Pair.of((Object)"LIEN", (Object)"SOURCE_CODE"), false));
        columns.add(new DefaultColumn("ACTIF", "NUMBER(1)", false));
        columns.add(new DefaultColumn("POIDS", "FLOAT", false));
        columns.add(new DefaultColumn("CHOIX_MINIMUM", "NUMBER", true));
        columns.add(new DefaultColumn("CHOIX_MAXIMUM", "NUMBER", true));
        columns.add(new ScenarioIdColumn());
        columns.add(new SourceIdColumn());
        return ExportUtils.initializeTableAndView(__TABLE_NAME, columns);
    }

    public static ParameterizableQuery deleteFrom() {
        return ExportUtils.deleteFromAmetys(__TABLE_NAME);
    }

    public static ParameterizableQuery insertInto(String code, Double weight, Long minChoice, Long maxChoice) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", code, 12));
        parameters.add(new ValuedQueryParameter("LIEN_ID", code, 12));
        parameters.add(new StaticQueryParameter("ACTIF", String.valueOf(1)));
        parameters.add(new ValuedQueryParameter("POIDS", weight, 6));
        parameters.add(new ValuedQueryParameter("CHOIX_MINIMUM", minChoice, 2));
        parameters.add(new ValuedQueryParameter("CHOIX_MAXIMUM", maxChoice, 2));
        return ExportUtils.insertIntoAmetys(__TABLE_NAME, parameters);
    }
}

