/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.AbstractOSEExport;
import org.ametys.odf.ose.export.impl.odf.CourseExporter;
import org.ametys.odf.ose.export.impl.odf.HierarchyExporter;
import org.ametys.odf.ose.export.impl.odf.ProgramPartExporter;
import org.ametys.odf.ose.export.impl.odf.StepExporter;
import org.ametys.odf.ose.export.impl.odf.db.CheminPedagogiqueHelper;
import org.ametys.odf.ose.export.impl.odf.db.EffectifsHelper;
import org.ametys.odf.ose.export.impl.odf.db.ElementPedagogiqueHelper;
import org.ametys.odf.ose.export.impl.odf.db.EtapeHelper;
import org.ametys.odf.ose.export.impl.odf.db.LienHelper;
import org.ametys.odf.ose.export.impl.odf.db.NoeudHelper;
import org.ametys.odf.ose.export.impl.odf.db.ScenarioHelper;
import org.ametys.odf.ose.export.impl.odf.db.ScenarioLienHelper;
import org.ametys.odf.ose.export.impl.odf.db.ScenarioNoeudHelper;
import org.ametys.odf.ose.export.impl.odf.db.TypeInterventionEPHelper;
import org.ametys.odf.ose.export.impl.odf.db.VolumeHoraireEnsHelper;
import org.ametys.odf.program.AbstractProgramPart;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ODFExport
extends AbstractOSEExport
implements Serviceable {
    protected StepExporter _stepExporter;
    protected CourseExporter _courseExporter;
    protected ProgramPartExporter _programElementExporter;
    protected HierarchyExporter _hierarchyExporter;
    protected ODFHelper _odfHelper;
    protected CostComputationComponent _costComputationComponent;

    public void service(ServiceManager manager) throws ServiceException {
        this._stepExporter = (StepExporter)((Object)manager.lookup(StepExporter.ROLE));
        this._courseExporter = (CourseExporter)((Object)manager.lookup(CourseExporter.ROLE));
        this._programElementExporter = (ProgramPartExporter)((Object)manager.lookup(ProgramPartExporter.ROLE));
        this._hierarchyExporter = (HierarchyExporter)((Object)manager.lookup(HierarchyExporter.ROLE));
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._costComputationComponent = (CostComputationComponent)manager.lookup(CostComputationComponent.ROLE);
    }

    @Override
    public List<ParameterizableQuery> initializeDb() {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.addAll(EtapeHelper.initialize());
        queries.addAll(ElementPedagogiqueHelper.initialize());
        queries.addAll(EffectifsHelper.initialize());
        queries.addAll(VolumeHoraireEnsHelper.initialize());
        queries.addAll(CheminPedagogiqueHelper.initialize());
        queries.addAll(TypeInterventionEPHelper.initialize());
        queries.addAll(NoeudHelper.initialize());
        queries.addAll(LienHelper.initialize());
        queries.addAll(ScenarioHelper.initialize());
        queries.addAll(ScenarioNoeudHelper.initialize());
        queries.addAll(ScenarioLienHelper.initialize());
        return queries;
    }

    @Override
    protected List<ParameterizableQuery> _populate(String ametysCatalog, Long oseCatalog) {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.addAll(this._deleteOldData());
        queries.addAll(new Populator(oseCatalog).exportSteps(ametysCatalog));
        return queries;
    }

    private List<ParameterizableQuery> _deleteOldData() {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.add(ScenarioLienHelper.deleteFrom());
        queries.add(ScenarioNoeudHelper.deleteFrom());
        queries.add(LienHelper.deleteFrom());
        queries.add(NoeudHelper.deleteFrom());
        queries.add(TypeInterventionEPHelper.deleteFrom());
        queries.add(CheminPedagogiqueHelper.deleteFrom());
        queries.add(VolumeHoraireEnsHelper.deleteFrom());
        queries.add(EffectifsHelper.deleteFrom());
        queries.add(ElementPedagogiqueHelper.deleteFrom());
        queries.add(EtapeHelper.deleteFrom());
        return queries;
    }

    private class Populator {
        private Set<String> _exportedObjectIds = new HashSet<String>();
        private Long _oseCatalog;

        Populator(Long oseCatalog) {
            this._oseCatalog = oseCatalog;
        }

        List<ParameterizableQuery> exportSteps(String ametysCatalog) {
            CostComputationData costData = this._getCostComputationData(ametysCatalog);
            ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
            for (Container step : ODFExport.this._stepExporter.getStepsToExport(ametysCatalog)) {
                if (!this._exportedObjectIds.add(step.getId())) continue;
                queries.addAll(ODFExport.this._stepExporter.getQueries(step, this._oseCatalog));
                queries.addAll(this._exportChildren((ProgramItem)step, costData));
            }
            return queries;
        }

        private CostComputationData _getCostComputationData(String ametysCatalog) {
            String lang = (String)Config.getInstance().getValue("odf.programs.lang");
            List programs = ODFExport.this._odfHelper.getProgramItems("org.ametys.plugins.odf.Content.program", null, ametysCatalog, lang).stream().filter(Program.class::isInstance).map(Program.class::cast).collect(Collectors.toList());
            return ODFExport.this._costComputationComponent.computeCostsOnPrograms(programs, false);
        }

        private List<ParameterizableQuery> _exportChildren(ProgramItem programItem, CostComputationData costData) {
            ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
            for (ProgramItem child : ODFExport.this._odfHelper.getChildProgramItems(programItem)) {
                if (!this._exportedObjectIds.add(child.getId())) continue;
                if (child instanceof Course) {
                    queries.addAll(this._exportCourse((Course)child, costData));
                } else {
                    queries.addAll(this._exportProgramPart((AbstractProgramPart)child, costData));
                }
                queries.addAll(ODFExport.this._hierarchyExporter.getQueries(programItem, child, this._oseCatalog));
            }
            return queries;
        }

        private List<ParameterizableQuery> _exportProgramPart(AbstractProgramPart programPart, CostComputationData costData) {
            ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
            if (!programPart.hasDefinition("noOseExport") || !((Boolean)programPart.getValue("noOseExport", true, (Object)false)).booleanValue()) {
                queries.addAll(ODFExport.this._programElementExporter.getQueries(programPart, this._oseCatalog, costData));
                queries.addAll(this._exportChildren((ProgramItem)programPart, costData));
            }
            return queries;
        }

        private List<ParameterizableQuery> _exportCourse(Course course, CostComputationData costData) {
            ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
            if (!((Boolean)course.getValue("noOseExport", true, (Object)false)).booleanValue()) {
                queries.addAll(ODFExport.this._courseExporter.getQueries(course, this._oseCatalog, costData));
                queries.addAll(this._exportChildren((ProgramItem)course, costData));
            }
            return queries;
        }
    }
}

