/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.List;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.impl.odf.db.LienHelper;
import org.ametys.odf.ose.export.impl.odf.db.ScenarioLienHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;

public class HierarchyExporter
extends AbstractLogEnabled
implements Component {
    public static final String ROLE = HierarchyExporter.class.getName();

    public List<ParameterizableQuery> getQueries(ProgramItem parent, ProgramItem child, Long oseCatalog) {
        String linkCode = oseCatalog + "_" + parent.getCode() + "-" + child.getCode();
        Double weight = 1.0;
        Long minChoice = null;
        Long maxChoice = null;
        if (parent instanceof CourseList) {
            CourseList courseList = (CourseList)parent;
            switch (courseList.getType()) {
                case OPTIONAL: {
                    weight = 0.0;
                    break;
                }
                case CHOICE: {
                    minChoice = courseList.getMinNumberOfCourses();
                    maxChoice = courseList.getMaxNumberOfCourses();
                    long size = courseList.getCourses().size();
                    if (minChoice > size) {
                        this.getLogger().warn("[{}] La liste contient min={} mais n'a que {} \u00e9l\u00e9ments.", new Object[]{courseList.getId(), minChoice, size});
                        break;
                    }
                    weight = (double)minChoice.longValue() / (double)size;
                    break;
                }
            }
        }
        return List.of(LienHelper.insertInto(linkCode, oseCatalog + "_" + parent.getCode(), oseCatalog + "_" + child.getCode()), ScenarioLienHelper.insertInto(linkCode, weight, minChoice, maxChoice));
    }
}

