/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.column.DefaultColumn;
import org.ametys.odf.ose.db.column.ForeignKeyColumn;
import org.ametys.odf.ose.db.column.SourceIdColumn;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.ExportUtils;
import org.ametys.odf.ose.export.impl.odf.db.NoeudHelper;
import org.ametys.odf.ose.export.impl.odf.db.ScenarioNoeudHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class ElementPedagogiqueHelper {
    private static final String __TABLE_NAME = "ELEMENT_PEDAGOGIQUE";

    private ElementPedagogiqueHelper() {
    }

    public static List<ParameterizableQuery> initialize() {
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new DefaultColumn("LIBELLE", "VARCHAR2(200 CHAR)", false));
        columns.add(new DefaultColumn("CODE", "VARCHAR2(50 CHAR)", false));
        columns.add(new ForeignKeyColumn("ETAPE_ID", "VARCHAR2(100 CHAR)", false, (Pair<String, String>)Pair.of((Object)"ETAPE", (Object)"SOURCE_CODE"), true));
        columns.add(new ForeignKeyColumn("STRUCTURE_ID", "VARCHAR2(100 CHAR)", false, (Pair<String, String>)Pair.of((Object)"STRUCTURE", (Object)"CODE"), false));
        columns.add(new ForeignKeyColumn("PERIODE_ID", "VARCHAR2(3 CHAR)", true, (Pair<String, String>)Pair.of((Object)"PERIODE", (Object)"CODE"), false));
        columns.add(new DefaultColumn("ANNEE_ID", "NUMBER(38, 0)", false));
        columns.add(new SourceIdColumn());
        return ExportUtils.initializeTableAndView(__TABLE_NAME, columns);
    }

    public static ParameterizableQuery deleteFrom() {
        return ExportUtils.deleteFromAmetys(__TABLE_NAME);
    }

    private static ParameterizableQuery _insertInto(String code, String label, Long oseCatalog, String orgUnit, String stepHolder, String periodType) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", code, 12));
        parameters.add(new ValuedQueryParameter("LIBELLE", StringUtils.truncate((String)label, (int)200), 12));
        parameters.add(new ValuedQueryParameter("CODE", code, 12));
        parameters.add(new ValuedQueryParameter("STRUCTURE_ID", orgUnit, 12));
        parameters.add(new ValuedQueryParameter("ETAPE_ID", stepHolder, 12));
        parameters.add(new ValuedQueryParameter("PERIODE_ID", StringUtils.truncate((String)periodType, (int)3), 12));
        parameters.add(new ValuedQueryParameter("ANNEE_ID", oseCatalog, 2));
        return ExportUtils.insertIntoAmetys(__TABLE_NAME, parameters);
    }

    public static List<ParameterizableQuery> insertInto(String code, String label, Long oseCatalog, String orgUnit, String stepHolder, String periodType) {
        String nodeId = oseCatalog + "_" + code;
        return List.of(ElementPedagogiqueHelper._insertInto(code, label, oseCatalog, orgUnit, stepHolder, periodType), NoeudHelper.insertInto(nodeId, code, false, label, oseCatalog), ScenarioNoeudHelper.insertInto(nodeId));
    }
}

