/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.db.column;

import java.util.List;

import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;

/**
 * Column in the database
 */
public interface Column
{
    /**
     * Get the column description for creation.
     * @return The column description
     */
    public String getColumnDescription();
    
    /**
     * Get the view description for the view mapping.
     * @return The column description for a view
     */
    public String getViewDescription();
    
    /**
     * Get the parameters
     * @return the parameters to create the view
     */
    public List<ValuedQueryParameter> getViewParameters();
}
