/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.db.parameter;

/**
 * Object to represent a query parameter to add : value and type.
 */
public class ValuedQueryParameter implements QueryParameter
{
    private String _name;
    private Object _value;
    private int _type;
    
    /**
     * Constructor.
     * @param name The name of the parameter
     * @param value The value of the parameter, can be null for nullable columns
     * @param type The type of the parameter
     */
    public ValuedQueryParameter(String name, Object value, int type)
    {
        this._name = name;
        this._value = value;
        this._type = type;
    }

    @Override
    public String getName()
    {
        return _name;
    }
    
    @Override
    public String getParameter()
    {
        return ":" + _name;
    }
    
    /**
     * Get the value.
     * @return the value
     */
    public Object getValue()
    {
        return _value;
    }
    
    /**
     * Get the type.
     * @return the type
     */
    public int getType()
    {
        return _type;
    }
}
