/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.ose.export.impl.odf.LogUtils;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.model.ModelHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class ElementRetriever
extends PilotageHelper {
    public static final String ROLE = ElementRetriever.class.getName();
    private static final String __STEP_HOLDERS_BY_ITEM_CACHE_ID = ElementRetriever.class.getName() + "$stepHoldersByItem";
    protected AmetysObjectResolver _resolver;
    protected OdfReferenceTableHelper _refTableHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    protected String _getStepsHolderByItemCacheId() {
        return __STEP_HOLDERS_BY_ITEM_CACHE_ID;
    }

    protected Set<Container> _getStepsToCache(ProgramItem programItem, String yearId) {
        return this._mustNotExport(programItem) ? Collections.EMPTY_SET : super._getStepsToCache(programItem, yearId);
    }

    private boolean _mustNotExport(ProgramItem programItem) {
        if (programItem instanceof Course || programItem instanceof Container) {
            return (Boolean)((Content)programItem).getValue("noOseExport", false, (Object)false);
        }
        return false;
    }

    public Set<OrgUnit> retrieveOrgUnits(ProgramItem programItem) {
        return this._retrieveOrgUnits(programItem);
    }

    private Set<OrgUnit> _retrieveOrgUnits(ProgramItem parent) {
        return Optional.of(parent).map(this::_getDirectOrgUnit).map(Collections::singleton).orElseGet(() -> this._retrieveOrgUnitsFromParents(parent));
    }

    private Set<OrgUnit> _retrieveOrgUnitsFromParents(ProgramItem programItem) {
        return this._odfHelper.getParentProgramItems(programItem).stream().map(this::_retrieveOrgUnits).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private OrgUnit _getDirectOrgUnit(ProgramItem programItem) {
        List orgUnitIds = programItem.getOrgUnits();
        return this._resolveAllAndGetFirst(orgUnitIds, (ProgramItem)((Content)programItem));
    }

    private <T extends ProgramItem & Content> OrgUnit _resolveAllAndGetFirst(Collection<String> orgUnitIds, T programElement) {
        List<OrgUnit> orgUnits = orgUnitIds.stream().map(this::_resolve).filter(Objects::nonNull).collect(Collectors.toList());
        if (orgUnits.size() > 1) {
            LogUtils.programElementWarningOrgUnits(this.getLogger(), programElement, orgUnits);
        }
        return orgUnits.isEmpty() ? null : orgUnits.get(0);
    }

    private OrgUnit _resolve(String id) {
        try {
            return (OrgUnit)this._resolver.resolveById(id);
        }
        catch (AmetysRepositoryException e) {
            return null;
        }
    }

    public Set<OdfReferenceTableEntry> retrieveDegree(Container container) {
        return this._odfHelper.getParentPrograms((ProgramItem)container).stream().map(p -> (ContentValue)p.getValue("degree")).filter(Objects::nonNull).map(ContentValue::getContentIfExists).flatMap(Optional::stream).map(OdfReferenceTableEntry::new).collect(Collectors.toSet());
    }

    public Set<Container> retrieveStepsHolder(ProgramItem programItem) {
        Optional yearId = this._odfHelper.getYearId();
        if (yearId.isPresent()) {
            return this._getStepsHolder(programItem, (String)yearId.get());
        }
        return Set.of();
    }

    public Set<OdfReferenceTableEntry> retrievePeriodTypes(ProgramItem programItem) {
        return this.getSemesterId().map(id -> this._retrievePeriodTypes(programItem, (String)id)).orElse(Collections.EMPTY_SET);
    }

    private Set<OdfReferenceTableEntry> _retrievePeriodTypes(ProgramItem programItem, String semesterId) {
        return this._getPeriodType(programItem).map(Collections::singleton).orElseGet(() -> this._searchPeriodTypesInParents(programItem, semesterId));
    }

    private Set<OdfReferenceTableEntry> _searchPeriodTypesInParents(ProgramItem programItem, String semesterId) {
        if (this._odfHelper.isContainerOfNature(programItem, semesterId)) {
            return Collections.EMPTY_SET;
        }
        return this._odfHelper.getParentProgramItems(programItem).stream().map(parent -> this._retrievePeriodTypes((ProgramItem)parent, semesterId)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Optional<OdfReferenceTableEntry> _getPeriodType(ProgramItem programItem) {
        return Optional.of(programItem).map(Content.class::cast).filter(c -> ModelHelper.hasModelItem((String)"period", (Collection)c.getModel())).map(c -> (ContentValue)c.getValue("period")).flatMap(ContentValue::getContentIfExists).map(c -> (ContentValue)c.getValue("type")).flatMap(ContentValue::getContentIfExists).map(OdfReferenceTableEntry::new);
    }

    public Optional<String> getSemesterId() {
        return Optional.of(this._refTableHelper).map(rth -> rth.getItemFromCode("odf-enumeration.ContainerNature", "semestre")).map(OdfReferenceTableEntry::getId).filter(StringUtils::isNotBlank);
    }
}

