/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.export.impl.odf.db;

import java.util.List;

import org.ametys.odf.ose.db.ParameterizableQuery;

/**
 * Helper to build queries to manage the SCENARIO table.
 */
public final class ScenarioHelper
{
    private ScenarioHelper()
    {
        // Helper
    }
    
    /**
     * Query to create a scenario.
     * @return The creation queries of the scenario
     */
    public static List<ParameterizableQuery> initialize()
    {
        return List.of(
                new ParameterizableQuery("DELETE FROM SCENARIO WHERE LIBELLE = 'Ametys'", List.of()),
                new ParameterizableQuery("INSERT INTO SCENARIO (ID, LIBELLE, TYPE, HISTO_CREATEUR_ID, HISTO_MODIFICATEUR_ID) VALUES (SCENARIO_ID_SEQ.NEXTVAL, 'Ametys', 1, 1, 1)", List.of())
            );
    }
}
