/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.export.impl.odf.AbstractProgramElementExporter;
import org.ametys.odf.ose.export.impl.odf.db.CheminPedagogiqueHelper;
import org.ametys.odf.ose.export.impl.odf.db.EffectifsHelper;
import org.ametys.odf.ose.export.impl.odf.db.ElementPedagogiqueHelper;
import org.ametys.odf.ose.export.impl.odf.db.TypeInterventionEPHelper;
import org.ametys.odf.ose.export.impl.odf.db.VolumeHoraireEnsHelper;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.model.ModelHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class CourseExporter
extends AbstractProgramElementExporter<Course> {
    public static final String ROLE = CourseExporter.class.getName();
    protected OdfReferenceTableHelper _refTableHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    @Override
    protected List<ParameterizableQuery> _getQueries(Course programElement, AbstractProgramElementExporter.ProgramElementData data, Long oseCatalog, CostComputationData costData) {
        ArrayList<ParameterizableQuery> queries;
        block2: {
            CoursePart[] holdedCourseParts;
            List courseParts;
            String courseCode;
            block3: {
                courseCode = programElement.getCode();
                String courseTitle = this._getCourseTitle(programElement);
                queries = new ArrayList<ParameterizableQuery>();
                queries.addAll(ElementPedagogiqueHelper.insertInto(courseCode, courseTitle, oseCatalog, data.getOrgUnit(), data.getStepHolder(), data.getPeriodType()));
                if (!programElement.getCourseLists().isEmpty()) break block2;
                courseParts = programElement.getCourseParts();
                boolean hasSharedCoursePart = this._hasSharedCoursePart(courseParts);
                holdedCourseParts = (CoursePart[])courseParts.stream().filter(coursePart -> this._isCourseHolder((CoursePart)coursePart, programElement)).toArray(CoursePart[]::new);
                if (!hasSharedCoursePart) break block3;
                for (CoursePart coursePart2 : holdedCourseParts) {
                    String coursePartCode = coursePart2.getCode();
                    String coursePartNature = this._refTableHelper.getItemCode(coursePart2.getNature());
                    String coursePartLabel = courseTitle + " - " + coursePartNature;
                    queries.addAll(ElementPedagogiqueHelper.insertInto(coursePartCode, coursePartLabel, oseCatalog, data.getOrgUnit(), data.getStepHolder(), data.getPeriodType()));
                    queries.addAll(this._getCheminPedagogiqueQueries(data.getSteps(), coursePartCode, oseCatalog));
                    this._getEffectifsQuery(coursePart2, coursePartCode, oseCatalog, costData).ifPresent(queries::add);
                    queries.addAll(this._getCoursePartQueries(coursePart2, coursePartNature, oseCatalog, coursePart2.getCode(), costData));
                }
                break block2;
            }
            queries.addAll(this._getCheminPedagogiqueQueries(data.getSteps(), courseCode, oseCatalog));
            if (courseParts.isEmpty()) break block2;
            this._getEffectifsQuery((CoursePart)courseParts.get(0), courseCode, oseCatalog, costData).ifPresent(queries::add);
            for (CoursePart coursePart3 : holdedCourseParts) {
                String coursePartNature = this._refTableHelper.getItemCode(coursePart3.getNature());
                queries.addAll(this._getCoursePartQueries(coursePart3, coursePartNature, oseCatalog, courseCode, costData));
            }
        }
        return queries;
    }

    private Optional<ParameterizableQuery> _getEffectifsQuery(CoursePart coursePart, String code, Long oseCatalog, CostComputationData costData) {
        return Optional.ofNullable(coursePart).map(c -> this._getNumberOfStudents((CoursePart)c, costData)).map(nbStudents -> EffectifsHelper.insertInto(coursePart.getCode(), nbStudents, oseCatalog, code));
    }

    private List<ParameterizableQuery> _getCheminPedagogiqueQueries(Set<Container> steps, String code, Long oseCatalog) {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        AtomicInteger order = new AtomicInteger();
        for (Container step : steps) {
            queries.add(CheminPedagogiqueHelper.insertInto(step.getCode(), code, oseCatalog, order));
        }
        return queries;
    }

    private List<ParameterizableQuery> _getCoursePartQueries(CoursePart coursePart, String coursePartNature, Long oseCatalog, String courseLink, CostComputationData costData) {
        String coursePartCode = coursePart.getCode();
        Double numberOfGroups = this._getGroups(coursePart, costData);
        return List.of(VolumeHoraireEnsHelper.insertInto(coursePart, coursePartCode, coursePartNature, oseCatalog, courseLink, numberOfGroups), TypeInterventionEPHelper.insertInto(coursePartCode, coursePartNature, courseLink, oseCatalog));
    }

    private boolean _hasSharedCoursePart(List<CoursePart> courseParts) {
        return courseParts.stream().map(CoursePart::getCourses).map(List::size).anyMatch(size -> size > 2);
    }

    private boolean _isCourseHolder(CoursePart coursePart, Course currentCourse) {
        String currentCourseId = currentCourse.getId();
        return Optional.of(coursePart).map(CoursePart::getCourseHolder).map(SimpleAmetysObject::getId).map(id -> id.equals(currentCourseId)).orElse(false);
    }

    private Long _getNumberOfStudents(CoursePart coursePart, CostComputationData costData) {
        return Optional.of(coursePart).map(SimpleAmetysObject::getId).map(arg_0 -> costData.get(arg_0)).map(ProgramItemData::getEffectives).flatMap(Effectives::getComputedEffective).map(Double::longValue).orElse(0L);
    }

    private Double _getGroups(CoursePart coursePart, CostComputationData costData) {
        Optional<Groups> groups = Optional.of(coursePart).map(SimpleAmetysObject::getId).map(arg_0 -> costData.get(arg_0)).map(ProgramItemData::getGroups);
        if (groups.isPresent()) {
            return groups.map(Groups::getGroupsToOpen).or(() -> groups.map(Groups::getComputedGroups)).map(Long::doubleValue).orElse(null);
        }
        return null;
    }

    private String _getCourseTitle(Course course) {
        String apogee;
        Object title = course.getTitle();
        if (ModelHelper.hasModelItem((String)"elpCode", (Collection)course.getModel()) && StringUtils.isNotEmpty((CharSequence)(apogee = (String)course.getValue("elpCode")))) {
            title = (String)title + " (" + apogee + ")";
        }
        return title;
    }
}

