/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.column.DefaultColumn;
import org.ametys.odf.ose.db.column.ForeignKeyColumn;
import org.ametys.odf.ose.db.column.SourceIdColumn;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.StaticQueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.ExportUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class NoeudHelper {
    private static final String __TABLE_NAME = "NOEUD";

    private NoeudHelper() {
    }

    public static List<ParameterizableQuery> initialize() {
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new DefaultColumn("CODE", "VARCHAR2(50 CHAR)", false));
        columns.add(new DefaultColumn("LIBELLE", "VARCHAR2(255 CHAR)", false));
        columns.add(new DefaultColumn("LISTE", "NUMBER(1)", false));
        columns.add(new ForeignKeyColumn("ETAPE_ID", "VARCHAR2(100 CHAR)", true, (Pair<String, String>)Pair.of((Object)"ETAPE", (Object)"SOURCE_CODE"), true));
        columns.add(new ForeignKeyColumn("ELEMENT_PEDAGOGIQUE_ID", "VARCHAR2(100 CHAR)", true, (Pair<String, String>)Pair.of((Object)"ELEMENT_PEDAGOGIQUE", (Object)"SOURCE_CODE"), true));
        columns.add(new DefaultColumn("ANNEE_ID", "NUMBER(38, 0)", false));
        columns.add(new SourceIdColumn());
        return ExportUtils.initializeTableAndView(__TABLE_NAME, columns);
    }

    public static ParameterizableQuery deleteFrom() {
        return ExportUtils.deleteFromAmetys(__TABLE_NAME);
    }

    public static ParameterizableQuery insertInto(String nodeId, String code, boolean isEtape, String title, Long oseCatalog) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", nodeId, 12));
        parameters.add(new ValuedQueryParameter("CODE", code, 12));
        parameters.add(new ValuedQueryParameter("LIBELLE", StringUtils.truncate((String)title, (int)255), 12));
        parameters.add(new StaticQueryParameter("LISTE", String.valueOf(0)));
        parameters.add(new ValuedQueryParameter("ETAPE_ID", isEtape ? code : null, 12));
        parameters.add(new ValuedQueryParameter("ELEMENT_PEDAGOGIQUE_ID", isEtape ? null : code, 12));
        parameters.add(new ValuedQueryParameter("ANNEE_ID", oseCatalog, 2));
        return ExportUtils.insertIntoAmetys(__TABLE_NAME, parameters);
    }
}

