/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.StaticQueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.AbstractOSEExport;
import org.ametys.odf.ose.export.ExportUtils;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class TypePeriodeExport
extends AbstractOSEExport
implements Serviceable {
    private static final String __TABLE_NAME = "PERIODE";
    protected OdfReferenceTableHelper _refTableHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    @Override
    public List<ParameterizableQuery> initializeDb() {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.add(this._deleteOldData());
        queries.addAll(this._getInsertQueries());
        return queries;
    }

    @Override
    protected List<ParameterizableQuery> _populate(String ametysCatalog, Long oseCatalog) {
        return Collections.EMPTY_LIST;
    }

    private ParameterizableQuery _deleteOldData() {
        return ExportUtils.deleteFrom(__TABLE_NAME);
    }

    private List<ParameterizableQuery> _getInsertQueries() {
        AtomicInteger order = new AtomicInteger();
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        return ((Stream)this._refTableHelper.getItems("odf-enumeration.PeriodType").stream().sequential()).sorted(Comparator.comparingLong(OdfReferenceTableEntry::getOrder).thenComparing(OdfReferenceTableEntry::getCode)).map(enseignementNature -> this._getInsertQuery((OdfReferenceTableEntry)enseignementNature, order, lang)).collect(Collectors.toList());
    }

    private ParameterizableQuery _getInsertQuery(OdfReferenceTableEntry typePeriode, AtomicInteger order, String lang) {
        String label = typePeriode.getLabel(lang);
        List<QueryParameter> queryParameters = Arrays.asList(new StaticQueryParameter("ID", "PERIODE_ID_SEQ.NEXTVAL"), new ValuedQueryParameter("CODE", StringUtils.truncate((String)typePeriode.getCode(), (int)3), 12), new ValuedQueryParameter("LIBELLE_LONG", StringUtils.truncate((String)label, (int)40), 12), new ValuedQueryParameter("LIBELLE_COURT", StringUtils.truncate((String)label, (int)15), 12), new ValuedQueryParameter("ORDRE", order.incrementAndGet(), 2), new StaticQueryParameter("ENSEIGNEMENT", String.valueOf(1)), new StaticQueryParameter("ECART_MOIS", String.valueOf(0)), new StaticQueryParameter("ECART_MOIS_PAIEMENT", String.valueOf(0)), new StaticQueryParameter("HISTO_CREATEUR_ID", String.valueOf(1)), new StaticQueryParameter("HISTO_MODIFICATEUR_ID", String.valueOf(1)));
        return ExportUtils.insertInto(__TABLE_NAME, queryParameters);
    }
}

