/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.column.DefaultColumn;
import org.ametys.odf.ose.db.column.ForeignKeyColumn;
import org.ametys.odf.ose.db.column.SourceIdColumn;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.ExportUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class VolumeHoraireEnsHelper {
    private static final String __TABLE_NAME = "VOLUME_HORAIRE_ENS";

    private VolumeHoraireEnsHelper() {
    }

    public static List<ParameterizableQuery> initialize() {
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new DefaultColumn("HEURES", "FLOAT", false));
        columns.add(new ForeignKeyColumn("ELEMENT_PEDAGOGIQUE_ID", "VARCHAR2(100 CHAR)", false, (Pair<String, String>)Pair.of((Object)"ELEMENT_PEDAGOGIQUE", (Object)"SOURCE_CODE"), true));
        columns.add(new ForeignKeyColumn("TYPE_INTERVENTION_ID", "VARCHAR2(10 CHAR)", false, (Pair<String, String>)Pair.of((Object)"TYPE_INTERVENTION", (Object)"CODE"), false));
        columns.add(new DefaultColumn("GROUPES", "FLOAT", true));
        columns.add(new DefaultColumn("ANNEE_ID", "NUMBER(38, 0)", false));
        columns.add(new SourceIdColumn());
        return ExportUtils.initializeTableAndView(__TABLE_NAME, columns);
    }

    public static ParameterizableQuery deleteFrom() {
        return ExportUtils.deleteFromAmetys(__TABLE_NAME);
    }

    public static ParameterizableQuery insertInto(CoursePart coursePart, String coursePartCode, String coursePartNature, Long oseCatalog, String courseLink, Double numberOfGroups) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", coursePartCode, 12));
        parameters.add(new ValuedQueryParameter("HEURES", coursePart.getNumberOfHours(), 6));
        parameters.add(new ValuedQueryParameter("ELEMENT_PEDAGOGIQUE_ID", courseLink, 12));
        parameters.add(new ValuedQueryParameter("TYPE_INTERVENTION_ID", coursePartNature, 12));
        parameters.add(new ValuedQueryParameter("GROUPES", numberOfGroups, 6));
        parameters.add(new ValuedQueryParameter("ANNEE_ID", oseCatalog, 2));
        return ExportUtils.insertIntoAmetys(__TABLE_NAME, parameters);
    }
}

