/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.generators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.OSEExport;
import org.ametys.odf.ose.export.OSEExportExtensionPoint;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections4.ListUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExportInitGenerator
extends ServiceableGenerator {
    protected OSEExportExtensionPoint _oseExportEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._oseExportEP = (OSEExportExtensionPoint)((Object)this.manager.lookup(OSEExportExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        List<ParameterizableQuery> queries = this._retrieveQueries();
        this._saxQueries(queries);
    }

    protected List<ParameterizableQuery> _retrieveQueries() {
        return ListUtils.union(this._retrieveStaticQueries(), this._retrieveQueriesFromExtensions());
    }

    protected List<ParameterizableQuery> _retrieveStaticQueries() {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        String oseSourceCode = (String)Config.getInstance().getValue("ose.source.code");
        List<ValuedQueryParameter> queryParameters = Collections.singletonList(new ValuedQueryParameter("SOURCE_CODE", oseSourceCode, 12));
        queries.add(new ParameterizableQuery("DELETE FROM SOURCE WHERE CODE = :SOURCE_CODE", queryParameters));
        queries.add(new ParameterizableQuery("INSERT INTO SOURCE (ID, CODE, LIBELLE, IMPORTABLE) VALUES (SOURCE_ID_SEQ.NEXTVAL, :SOURCE_CODE, 'Ametys', 1)", queryParameters));
        return queries;
    }

    protected List<ParameterizableQuery> _retrieveQueriesFromExtensions() {
        return this._oseExportEP.getExtensionsIds().stream().map(arg_0 -> ((OSEExportExtensionPoint)this._oseExportEP).getExtension(arg_0)).map(OSEExport::initializeDb).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected void _saxQueries(List<ParameterizableQuery> queries) throws SAXException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"queries");
        for (ParameterizableQuery query : queries) {
            String queryText = this._queryText(query);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"query", (String)queryText);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"queries");
        this.contentHandler.endDocument();
    }

    protected String _queryText(ParameterizableQuery query) {
        String queryText = query.getQuery();
        for (ValuedQueryParameter parameter : query.getParameters()) {
            String target = ":" + parameter.getName();
            String replacement = "'" + parameter.getValue().toString().replace("'", "''") + "'";
            queryText = queryText.replace(target, replacement);
        }
        return queryText;
    }
}

