/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl.odf;

import java.util.Collection;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.runtime.config.Config;
import org.slf4j.Logger;

public final class LogUtils {
    private LogUtils() {
    }

    public static void stepImpossibilityDegreesOrOrgunits(Logger logger, Container container, Collection<OdfReferenceTableEntry> degrees, Collection<OrgUnit> orgUnits) {
        logger.error("[{}] Impossible to export the step '{}' ({}) to OSE, the degree ({}) or the orgunit ({}) can't be defined.", new Object[]{container.getId(), container.getTitle(), container.getCode(), LogUtils._readableRefTablesEntries(degrees), LogUtils._readableOrgUnits(orgUnits)});
    }

    public static void stepImpossibilityFunctDomain(Logger logger, Container container) {
        logger.error("[{}] Impossible to export the step '{}' ({}) to OSE, there is no associated functional domain.", new Object[]{container.getId(), container.getTitle(), container.getCode()});
    }

    public static <T extends ProgramItem & Content> void programElementImpossibilityStepsOrOrgunits(Logger logger, T programElement, Collection<Container> steps, Collection<OrgUnit> orgUnits) {
        logger.error("[{}] Impossible to export the program element '{}' ({}) to OSE, the step holder ({}) or the orgunit ({}) can't be defined.", new Object[]{programElement.getId(), ((Content)programElement).getTitle(), programElement.getCode(), LogUtils._readableProgramElements(steps), LogUtils._readableOrgUnits(orgUnits)});
    }

    public static <T extends ProgramItem & Content> void programElementWarningOrgUnits(Logger logger, T programElement, Collection<OrgUnit> orgUnits) {
        logger.warn("[{}] There are several orgunits ({}) on the program element '{}' ({}), by default the first one has been selected.", new Object[]{programElement.getId(), LogUtils._readableOrgUnits(orgUnits), ((Content)programElement).getTitle(), programElement.getCode()});
    }

    public static <T extends ProgramItem & Content> void programElementWarningPeriodTypes(Logger logger, T programElement, Collection<OdfReferenceTableEntry> periodTypes) {
        logger.warn("[{}] Impossible to export the period type of program element '{}' ({}) to OSE, there are the following values : {}.", new Object[]{programElement.getId(), ((Content)programElement).getTitle(), programElement.getCode(), LogUtils._readableRefTablesEntries(periodTypes)});
    }

    public static <T extends ProgramItem & Content> void programElementDebugIsNotContainedInSteps(Logger logger, T programElement, Container stepHolder, Collection<Container> steps) {
        if (logger.isDebugEnabled()) {
            String readableSteps = LogUtils._readableProgramElements(steps);
            logger.debug("[{}] The program element '{}' ({}) will not be exported to OSE, as the step holder '{}' ({}) is not among the steps [{}].", new Object[]{programElement.getId(), ((Content)programElement).getTitle(), programElement.getCode(), stepHolder.getTitle(), stepHolder.getCode(), readableSteps});
        }
    }

    private static <T extends ProgramItem & Content> String _readableProgramElements(Collection<T> programElements) {
        return programElements.stream().map(programElement -> ((Content)programElement).getTitle() + " (" + programElement.getCode() + ")").collect(Collectors.joining(", "));
    }

    private static String _readableRefTablesEntries(Collection<OdfReferenceTableEntry> entries) {
        return entries.stream().map(entry -> entry.getLabel((String)Config.getInstance().getValue("odf.programs.lang")) + " (" + entry.getCode() + ")").collect(Collectors.joining(", "));
    }

    private static String _readableOrgUnits(Collection<OrgUnit> orgUnits) {
        return orgUnits.stream().map(orgUnit -> orgUnit.getTitle() + " (" + orgUnit.getUAICode() + ")").collect(Collectors.joining(", "));
    }
}

