/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.db.column;

import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.runtime.config.Config;

/**
 * This column is only used in the SRC_* view to reference the right source from the SOURCE table.
 */
public class SourceIdColumn implements Column
{
    @Override
    public String getColumnDescription()
    {
        return null;
    }

    @Override
    public String getViewDescription()
    {
        return "(SELECT SRC.ID FROM SOURCE SRC WHERE SRC.CODE = :SOURCE_CODE) AS SOURCE_ID";
    }

    @Override
    public List<ValuedQueryParameter> getViewParameters()
    {
        List<ValuedQueryParameter> parameters = new ArrayList<>();
        parameters.add(new ValuedQueryParameter("SOURCE_CODE", Config.getInstance().getValue("ose.source.code"), Types.VARCHAR));
        return parameters;
    }
}
