/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.odf.ose.export.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.ContentValue;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.ose.db.ParameterizableQuery;
import org.ametys.odf.ose.db.column.Column;
import org.ametys.odf.ose.db.column.DefaultColumn;
import org.ametys.odf.ose.db.column.ForeignKeyColumn;
import org.ametys.odf.ose.db.column.SourceIdColumn;
import org.ametys.odf.ose.db.parameter.QueryParameter;
import org.ametys.odf.ose.db.parameter.ValuedQueryParameter;
import org.ametys.odf.ose.export.AbstractOSEExport;
import org.ametys.odf.ose.export.ExportUtils;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TypeFormationExport
extends AbstractOSEExport
implements Serviceable {
    private static final String __GROUPE_TYPE_TABLE_NAME = "GROUPE_TYPE_FORMATION";
    private static final String __TYPE_TABLE_NAME = "TYPE_FORMATION";
    private static final String __DEGREE_CATEGORY_CONTENT_TYPE = "odf-enumeration.DegreeCategory";
    private static final String __DEGREES_ATTRIBUTE_NAME = "degrees";
    protected OdfReferenceTableHelper _refTableHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._refTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    @Override
    public List<ParameterizableQuery> initializeDb() {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new DefaultColumn("LIBELLE_COURT", "VARCHAR2(20 CHAR)", false));
        columns.add(new DefaultColumn("LIBELLE_LONG", "VARCHAR2(50 CHAR)", false));
        columns.add(new DefaultColumn("ORDRE", "NUMBER(*,0)", false));
        columns.add(new SourceIdColumn());
        queries.addAll(ExportUtils.initializeTableAndView(__GROUPE_TYPE_TABLE_NAME, columns));
        columns = new HashSet();
        columns.add(new DefaultColumn("ID", "VARCHAR2(100 CHAR)", false, "SOURCE_CODE"));
        columns.add(new DefaultColumn("LIBELLE_LONG", "VARCHAR2(80 CHAR)", false));
        columns.add(new DefaultColumn("LIBELLE_COURT", "VARCHAR2(15 CHAR)", false));
        columns.add(new ForeignKeyColumn("GROUPE_ID", "VARCHAR2(100 CHAR)", false, (Pair<String, String>)Pair.of((Object)__GROUPE_TYPE_TABLE_NAME, (Object)"SOURCE_CODE"), false));
        columns.add(new SourceIdColumn());
        queries.addAll(ExportUtils.initializeTableAndView(__TYPE_TABLE_NAME, columns));
        return queries;
    }

    @Override
    public List<ParameterizableQuery> _populate(String ametysCatalog, Long oseCatalog) {
        ArrayList<ParameterizableQuery> queries = new ArrayList<ParameterizableQuery>();
        queries.add(ExportUtils.deleteFromAmetys(__TYPE_TABLE_NAME));
        queries.add(ExportUtils.deleteFromAmetys(__GROUPE_TYPE_TABLE_NAME));
        queries.addAll(this._getInsertQueries());
        return queries;
    }

    private List<ParameterizableQuery> _getInsertQueries() {
        String lang = (String)Config.getInstance().getValue("odf.programs.lang");
        return this._refTableHelper.getItems(__DEGREE_CATEGORY_CONTENT_TYPE).stream().sorted(Comparator.comparingLong(OdfReferenceTableEntry::getOrder).thenComparing(OdfReferenceTableEntry::getCode)).flatMap(degreeCategory -> this._getInsertQueries((OdfReferenceTableEntry)degreeCategory, lang)).collect(Collectors.toList());
    }

    private Stream<ParameterizableQuery> _getInsertQueries(OdfReferenceTableEntry degreeCategory, String lang) {
        ContentValue[] degrees;
        Stream.Builder<ParameterizableQuery> queries = Stream.builder();
        queries.add(this._getInsertQueryForGroupType(degreeCategory, lang));
        String degreeCategoryCode = degreeCategory.getCode();
        for (ContentValue degree : degrees = (ContentValue[])degreeCategory.getContent().getValue(__DEGREES_ATTRIBUTE_NAME, false, (Object)new ContentValue[0])) {
            degree.getContentIfExists().map(OdfReferenceTableEntry::new).map(entry -> this._getInsertQueryForType((OdfReferenceTableEntry)entry, lang, degreeCategoryCode)).ifPresent(queries::add);
        }
        return queries.build();
    }

    private ParameterizableQuery _getInsertQueryForGroupType(OdfReferenceTableEntry degreeCategory, String lang) {
        String code = degreeCategory.getCode();
        String label = degreeCategory.getLabel(lang);
        Long order = degreeCategory.getOrder();
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", code, 12));
        parameters.add(new ValuedQueryParameter("LIBELLE_COURT", StringUtils.truncate((String)label, (int)20), 12));
        parameters.add(new ValuedQueryParameter("LIBELLE_LONG", StringUtils.truncate((String)label, (int)50), 12));
        parameters.add(new ValuedQueryParameter("ORDRE", order, 2));
        return ExportUtils.insertIntoAmetys(__GROUPE_TYPE_TABLE_NAME, parameters);
    }

    private ParameterizableQuery _getInsertQueryForType(OdfReferenceTableEntry degree, String lang, String degreeCategoryCode) {
        String code = degree.getCode();
        String label = degree.getLabel(lang);
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        parameters.add(new ValuedQueryParameter("ID", code, 12));
        parameters.add(new ValuedQueryParameter("LIBELLE_LONG", StringUtils.truncate((String)label, (int)80), 12));
        parameters.add(new ValuedQueryParameter("LIBELLE_COURT", StringUtils.truncate((String)label, (int)15), 12));
        parameters.add(new ValuedQueryParameter("GROUPE_ID", degreeCategoryCode, 12));
        return ExportUtils.insertIntoAmetys(__TYPE_TABLE_NAME, parameters);
    }
}

