/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.ose.export;

import java.util.List;

import org.ametys.odf.ose.db.ParameterizableQuery;

/**
 * Interface for OSE export.
 */
public interface OSEExport
{
    /**
     * Initialize the database by dropping old Ametys tables and source views and activate import on the OSE tables.
     * @return A {@link List} of queries
     */
    public List<ParameterizableQuery> initializeDb();
    
    /**
     * Populate the database with Ametys data.
     * @param ametysCatalog The Ametys catalog to filter 
     * @param oseCatalog The OSE year
     */
    public void populate(String ametysCatalog, Long oseCatalog);
}
