/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.cms.workflow.EditContentAccessDeniedException;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.courselist.CourseListContainer;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Program;
import org.ametys.odf.tree.ODFContentsTreeHelper;
import org.ametys.plugins.contentstree.TreeConfiguration;
import org.ametys.plugins.odfpilotage.cost.CostComputationComponent;
import org.ametys.plugins.odfpilotage.cost.entity.CostComputationData;
import org.ametys.plugins.odfpilotage.cost.entity.Effectives;
import org.ametys.plugins.odfpilotage.cost.entity.EqTD;
import org.ametys.plugins.odfpilotage.cost.entity.Groups;
import org.ametys.plugins.odfpilotage.cost.entity.NormDetails;
import org.ametys.plugins.odfpilotage.cost.entity.OverriddenData;
import org.ametys.plugins.odfpilotage.cost.entity.ProgramItemData;
import org.ametys.plugins.odfpilotage.cost.entity.VolumesOfHours;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.model.View;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.lang3.StringUtils;

public class CostComputationTreeHelper
extends ODFContentsTreeHelper
implements Contextualizable {
    private static int _ACTION = 2;
    private static final String __COST_DATA_KEY = "cost-data-key";
    protected CostComputationComponent _costComputationComponent;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected I18nUtils _i18nUtils;
    protected PilotageHelper _pilotageHelper;
    protected ODFHelper _odfHelper;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._costComputationComponent = (CostComputationComponent)((Object)smanager.lookup(CostComputationComponent.ROLE));
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)smanager.lookup(PilotageHelper.ROLE));
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
    }

    protected CostComputationData _getCostData() {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession();
        CostComputationData costData = (CostComputationData)session.getAttribute(__COST_DATA_KEY);
        if (costData == null) {
            throw new UnsupportedOperationException("Cost data is not initalized in session attribute 'cost-data-key'");
        }
        return costData;
    }

    protected void _setCostData(CostComputationData costData) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession();
        session.setAttribute(__COST_DATA_KEY, (Object)costData);
    }

    protected void _launchCostComputation(Content content, String catalog, String lang, OverriddenData overriddenData) {
        CostComputationData costData;
        if (content instanceof OrgUnit) {
            OrgUnit orgUnit = (OrgUnit)content;
            v0 = this._costComputationComponent.computeCostsOnOrgUnit(orgUnit, catalog, lang, false, overriddenData);
        } else if (content instanceof Program) {
            Program program = (Program)content;
            v0 = this._costComputationComponent.computeCostsOnProgram(program, false, overriddenData);
        } else {
            v0 = costData = null;
        }
        if (costData != null) {
            this._setCostData(costData);
        }
    }

    protected Map<String, List<Content>> _getChildrenContent(Content parentContent, TreeConfiguration treeConfiguration, String catalog, String lang) {
        HashMap<String, List<Content>> children = new HashMap();
        if (parentContent instanceof OrgUnit) {
            OrgUnit orgUnit = (OrgUnit)parentContent;
            List contents = orgUnit.getSubOrgUnits().stream().map(this::_resolveSilently).filter(Objects::nonNull).collect(Collectors.toList());
            if (orgUnit.getParentOrgUnit() == null && !contents.isEmpty()) {
                children.put("childOrgUnits", contents);
            } else {
                List programs = this._odfHelper.getProgramsFromOrgUnit((OrgUnit)parentContent, catalog, lang);
                contents = programs.stream().filter(Content.class::isInstance).map(Content.class::cast).collect(Collectors.toList());
                children.put("_programsLink", contents);
            }
        } else {
            children = super.getChildrenContent(parentContent, treeConfiguration);
        }
        return children;
    }

    @Callable
    public Map<String, Object> getChildrenContent(String contentId, String treeId, String contentPath, String catalog, String lang) {
        Course parentCourse;
        TreeConfiguration treeConfiguration = this._getTreeConfiguration(treeId);
        Content parentContent = this._getParentContent(contentId);
        Map<String, List<Content>> children = this._getChildrenContent(parentContent, treeConfiguration, catalog, lang);
        HashMap<String, Object> infos = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> childrenInfos = new ArrayList<Map<String, Object>>();
        infos.put("children", childrenInfos);
        boolean lastLevel = parentContent instanceof Course && !(parentCourse = (Course)parentContent).hasCourseLists();
        for (String attributePath : children.keySet()) {
            for (Content childContent : children.get(attributePath)) {
                if (!lastLevel && childContent instanceof CoursePart) continue;
                Map<String, Object> childInfo = this.content2Json(childContent, contentPath + "/" + childContent.getName());
                childInfo.put("metadataPath", attributePath);
                if (!this.hasChildrenContent(childContent, treeConfiguration)) {
                    childInfo.put("children", Collections.EMPTY_LIST);
                }
                childrenInfos.add(childInfo);
            }
        }
        return infos;
    }

    @Callable
    public Map<String, Object> getRootNodeInformations(String contentId, String catalog, String lang, Map<String, Map<String, String>> overriddenData) {
        return this.getNodeInformations(contentId, catalog, lang, overriddenData);
    }

    @Callable
    public Map<String, Object> getNodeInformations(String contentId, String catalog, String lang, Map<String, Map<String, String>> overriddenData) {
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        this._launchCostComputation(content, catalog, lang, new OverriddenData(overriddenData));
        Map<String, Object> json = this.content2Json(content, content.getName());
        if (content instanceof Program) {
            Program program = (Program)content;
            json.put("lang", program.getLanguage());
            json.put("catalog", program.getCatalog());
        }
        return json;
    }

    protected Map<String, Object> content2Json(Content content, String contentPath) {
        Map infos = super.content2Json(content);
        CostComputationData costData = this._getCostData();
        ProgramItemData data = (ProgramItemData)costData.get(content.getId());
        if (data != null && !(content instanceof CourseList)) {
            String realContentPath = !(content instanceof OrgUnit) && this._ametysResolver.query(QueryHelper.getXPathQuery((String)StringUtils.substringBefore((String)contentPath, (String)"/"), (String)"ametys:orgunitContent", null)).getSize() > 0L ? StringUtils.substringAfter((String)contentPath, (String)"/") : contentPath;
            infos.putAll(this._programItemData2json(data, realContentPath));
        }
        return infos;
    }

    private Map<String, Object> _programItemData2json(ProgramItemData data, String contentPath) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("effectives", this._effectives2json(data.getEffectives(), contentPath));
        json.put("groups", this._groups2json(data.getGroups()));
        json.put("norm", this._normDetails2json(data.getNormDetails()));
        json.put("volumesOfHours", this._volumesOfHours2json(data.getVolumesOfHours()));
        json.put("eqTD", this._eqTD2json(data.getEqTD(), contentPath));
        data.getHeRatio(contentPath).ifPresent(heRatio -> json.put("heRatio", heRatio));
        return json;
    }

    private Map<String, Object> _effectives2json(Effectives effectives, String contentPath) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (effectives != null) {
            effectives.getOverriddenEffective().map(Math::round).ifPresent(eff -> json.put("overridden", eff));
            effectives.getEnteredEffective().map(Math::round).ifPresent(eff -> json.put("entered", eff));
            effectives.getEstimatedEffective().map(Math::round).ifPresent(eff -> json.put("estimated", eff));
            effectives.getComputedEffective().map(Math::round).ifPresent(eff -> json.put("computed", eff));
            Optional.of(contentPath).map(effectives::getLocalEffective).map(Math::round).ifPresent(eff -> json.put("local", eff));
            TreeMap<String, Double> distribution = new TreeMap<String, Double>();
            Map<String, Double> estimatedEffectives = effectives.getEstimatedEffectiveByPath();
            for (String path : estimatedEffectives.keySet()) {
                distribution.put(this._pilotageHelper.getDisplayablePath(path), estimatedEffectives.get(path));
            }
            json.put("distribution", distribution);
        }
        return json;
    }

    private Map<String, Object> _groups2json(Groups groups) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (groups != null) {
            json.put("overridden", groups.getOverriddenGroups());
            json.put("entered", groups.getGroupsToOpen());
            json.put("computed", groups.getComputedGroups());
        }
        return json;
    }

    private Map<String, Object> _normDetails2json(NormDetails normDetails) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (normDetails != null) {
            json.put("effMax", normDetails.getEffectiveMax());
            json.put("effMinSup", normDetails.getEffectiveMinSup());
            json.put("label", normDetails.getNormLabel());
        }
        return json;
    }

    private Map<String, Object> _volumesOfHours2json(VolumesOfHours volumesOfHours) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (volumesOfHours != null) {
            json.put("original", volumesOfHours.getOriginalVolumeOfHours());
            json.putAll(volumesOfHours.getVolumes());
        }
        return json;
    }

    private Map<String, Object> _eqTD2json(EqTD eqTD, String contentPath) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (eqTD != null) {
            json.put("global", eqTD.getGlobalEqTD());
            json.put("local", eqTD.getLocalEqTD(contentPath));
            json.put("prorated", eqTD.getProratedEqTD(contentPath));
        }
        return json;
    }

    private Content _resolveSilently(String contentId) {
        try {
            return (Content)this._ametysResolver.resolveById(contentId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    @Callable
    public Map<String, Map<String, Object>> refresh(Map<String, String> contentsToRefresh, String contentId, String catalog, String lang, Map<String, Map<String, String>> overriddenData) {
        HashMap<String, Map<String, Object>> refreshedData = new HashMap<String, Map<String, Object>>();
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        OverriddenData data = new OverriddenData(overriddenData);
        this._launchCostComputation(content, catalog, lang, data);
        for (Map.Entry<String, String> entry : contentsToRefresh.entrySet()) {
            Content item = (Content)this._ametysResolver.resolveById(entry.getValue());
            refreshedData.put(entry.getKey(), this.content2Json(item, entry.getKey()));
        }
        return refreshedData;
    }

    @Callable
    public Map<String, Object> getOldData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CostComputationData costData = this._getCostData();
        for (String itemId : costData.keySet()) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            ProgramItemData itemData = (ProgramItemData)costData.get(itemId);
            EqTD eqTD = itemData.getEqTD();
            if (eqTD != null) {
                itemMap.put("globalEqTD", eqTD.getGlobalEqTD());
                itemMap.put("proratedEqTD", eqTD.getProratedEqTD());
                itemMap.put("localEqTD", eqTD.getLocalEqTD());
            }
            itemMap.put("heRatio", itemData.getHeRatios().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElse(0.0))));
            data.put(itemId, itemMap);
        }
        return data;
    }

    @Callable
    public Map<String, Object> saveOverriddenData(Map<String, Map<String, String>> overriddenData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, String>> data : overriddenData.entrySet()) {
            String contentId = data.getKey();
            Map<String, String> contentValues = data.getValue();
            if (contentValues.isEmpty()) continue;
            String status = null;
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("id", contentId);
            try {
                ModifiableDefaultContent content = (ModifiableDefaultContent)this._ametysResolver.resolveById(data.getKey());
                json.put("title", content.getTitle());
                if (content.hasValue("code")) {
                    json.put("code", (String)content.getValue("code"));
                }
                HashMap values = new HashMap();
                if (content instanceof CoursePart) {
                    Optional.of("groups").map(contentValues::get).map(Long::parseLong).filter(v -> !Objects.equals(content.getValue("groupsToOpen"), v)).ifPresent(v -> values.put("groupsToOpen", v));
                    Optional.of("nbHours").map(contentValues::get).map(Double::parseDouble).filter(v -> !Objects.equals(content.getValue("nbHours"), v)).ifPresent(v -> values.put("nbHours", v));
                } else if (content instanceof CourseListContainer) {
                    Optional.of("effectivesGlobal").map(contentValues::get).map(Long::parseLong).filter(v -> !Objects.equals(content.getValue("numberOfStudentsEstimated"), v)).ifPresent(v -> values.put("numberOfStudentsEstimated", v));
                }
                if (!values.isEmpty()) {
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)content, values, _ACTION, View.of((Collection)content.getModel(), (String[])((String[])values.keySet().toArray(String[]::new))));
                    status = "updated";
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("[SimulatorSaveData] Content {} has been updated from cost simulator", (Object)content.getTitle());
                    }
                }
            }
            catch (UnknownAmetysObjectException e) {
                status = "unknown";
                this.getLogger().warn("[SimulatorSaveData] Content '{}' doesn't exists anymore", (Object)contentId);
            }
            catch (InvalidActionException e) {
                status = "invalidAction";
                this.getLogger().warn("[SimulatorSaveData] Invalid edit action (could be a lack of rights) on content '{}'", (Object)contentId, (Object)e);
            }
            catch (WorkflowException e) {
                status = Optional.of(e).map(WorkflowException::getRootCause).filter(EditContentAccessDeniedException.class::isInstance).map(EditContentAccessDeniedException.class::cast).map(cause -> {
                    json.put("attributeLabel", this._i18nUtils.translate((I18nizable)cause.getModelItem().getLabel()));
                    json.put("attributePath", cause.getModelItem().getPath());
                    return "attributeRight";
                }).orElse("workflow");
                this.getLogger().warn("[SimulatorSaveData] Workflow problem on content '{}'", (Object)contentId, (Object)e);
            }
            catch (Exception e) {
                status = "error";
                this.getLogger().error("[SimulatorSaveData] Unknown error while updating content '{}'", (Object)contentId, (Object)e);
            }
            if (status == null) continue;
            List jsonContents = (List)result.computeIfAbsent(status, __ -> new ArrayList());
            jsonContents.add(json);
        }
        return result;
    }
}

