/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.right;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.rights.ContentAccessController;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ThematicAccessController
implements AccessController,
Serviceable,
PluginAware {
    private static final String __ALL_THEMATIC_CONTENT_FAKE_CONTEXT = "$allThematicContent$";
    private static List<String> _RIGHT_IDS = List.of("Workflow_Rights_Edition_Online");
    private ContentTypesHelper _contentTypesHelper;
    private RightManager _rightManager;
    private ThematicsHelper _thematicHelper;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._thematicHelper = (ThematicsHelper)manager.lookup(ThematicsHelper.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public boolean isSupported(Object object) {
        Content content;
        return object instanceof Content && this._contentTypesHelper.isInstanceOf(content = (Content)object, "odf-enumeration.Thematic");
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return Collections.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return Collections.EMPTY_MAP;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (_RIGHT_IDS.contains(rightId)) {
            return this._thematicHelper.hasHandleThematicRight(user) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (this._thematicHelper.hasHandleThematicRight(user)) {
            _RIGHT_IDS.stream().forEach(r -> permissionByRight.put((String)r, AccessController.AccessResult.USER_ALLOWED));
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (_RIGHT_IDS.contains(rightId)) {
            for (UserIdentity user : this._rightManager.getAllowedUsers("ODF_Rights_Thematics_Handle", (Object)"/${WorkspaceName}").getAllowedUsers()) {
                permissionByUser.put(user, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByUser;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Collections.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public AccessExplanation getStandardAccessExplanation(AccessController.AccessResult permission, Object object) {
        switch (permission) {
            case USER_ALLOWED: 
            case ANY_CONNECTED_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), permission, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_RIGHTS_THEMATICS_ACCESS_CONTROLLER_" + permission.name() + "_EXPLANATION", Map.of("objectLabel", this.getObjectLabelForExplanation(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)permission);
    }

    private I18nizableText getObjectLabelForExplanation(Object object) {
        if (object.equals(__ALL_THEMATIC_CONTENT_FAKE_CONTEXT)) {
            return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_RIGHTS_THEMATICS_ACCESS_CONTROLLER_ALL_THEMATICS_EXPLANATION_LABEL");
        }
        if (object instanceof Content) {
            Content content = (Content)object;
            return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_RIGHTS_THEMATICS_ACCESS_CONTROLLER_CONTENT_EXPLANATION_LABEL", Map.of("title", new I18nizableText(content.getTitle())));
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object.equals(__ALL_THEMATIC_CONTENT_FAKE_CONTEXT)) {
            return new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_RIGHTS_THEMATICS_ACCESS_CONTROLLER_ALL_THEMATICS_LABEL");
        }
        return new I18nizableText(((Content)object).getTitle());
    }

    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups) {
        HashMap<AccessController.Permission, AccessExplanation> contextPermissions = new HashMap<AccessController.Permission, AccessExplanation>();
        AccessExplanation explanation = this.explainReadAccessPermission(identity, groups, __ALL_THEMATIC_CONTENT_FAKE_CONTEXT);
        if (explanation.accessResult() != AccessController.AccessResult.UNKNOWN) {
            contextPermissions.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
        }
        for (String rightId : _RIGHT_IDS) {
            explanation = this.explainPermission(identity, groups, rightId, __ALL_THEMATIC_CONTENT_FAKE_CONTEXT);
            if (explanation.accessResult() == AccessController.AccessResult.UNKNOWN) continue;
            contextPermissions.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, rightId), explanation);
        }
        return Map.of(this.getExplanationObject(__ALL_THEMATIC_CONTENT_FAKE_CONTEXT), contextPermissions);
    }

    public I18nizableText getObjectCategory(Object object) {
        return ContentAccessController.CONTENT_CONTEXT_CATEGORY;
    }

    public int getObjectPriority(Object object) {
        if (object.equals(__ALL_THEMATIC_CONTENT_FAKE_CONTEXT)) {
            return 5;
        }
        return super.getObjectPriority(object);
    }

    public String getId() {
        return this._id;
    }
}

