<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:exsl="http://exslt.org/common"
                              xmlns:su="org.ametys.core.util.StringUtils"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                              exclude-result-prefixes="exsl cms docbook odf su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/params/mcc.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/report/mcc/legende2xls.xsl"/>
    
    <xsl:template name="css-styles">
        <xsl:call-template name="css-styles-mcc"/>
    </xsl:template>
    
    <xsl:template name="css-styles-mcc">
        table
        {
            width: 100%;
            padding: 0px;
            margin: 0px;
            border-spacing: 0;
            border-collapse: collapse;
            font-size: 7.5pt;
        }
        
        td
        {
            padding: 2pt;
            vertical-align: middle;
        }
        
        /** Header */
        
        table tr.new-header td
        {
            border-top: 1pt dashed lightgrey;
            font-size: 10pt;
        }
        
        table thead tr td.maquette
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #EEEEFF;
            border: 0.5pt #000080 solid;
            color: #000080;
        }
        
        table thead tr td.evaluation
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #000080;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead tr td.session1
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0000A0;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead tr td.session2
        {
            vertical-align: middle;
            font-weight: bold;
            text-align: center;
            background-color: #0020C2;
            border: 0.5pt white solid;
            color: white;
        }
        
        table thead td.main-title1
        {
            background-color: white;
            color: #000080;
            font-size: 20pt;
        }
        
        table thead td.main-title2
        {
            background-color: white;
            color: #000080;
            font-size: 18pt;
        }
        
        table thead td.main-title3
        {
            background-color: white;
            color: #000080;
            font-size: 16pt;
        }
        
        table tbody tr.courselist td
        {
            font-style: italic;
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.elp td
        {
            padding: 3px 1px;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr.first-ue td
        {
            padding: 3px 1px;
            font-weight: bold;
            border-top: 1pt black solid;
            border-bottom: 0.5pt #cccccc solid;
            border-right: 0.5pt #cccccc solid;
        }
        
        table tbody tr td.nature-ens
        {
            border-right: 0.5pt white solid;
        }
        
        table.main tbody tr td.first-cell
        {
            text-align: center;
            border-left: 0.5pt #cccccc solid;
        }
        
        table tbody tr td.session-cell
        {
            border-right: 0.5pt white solid;
        }
        
        table tbody tr td.session-cell-centered
        {
            border-right: 0.5pt white solid;
            text-align: center;
        }
        
        table tbody tr td.session-cell-coef
        {
            mso-number-format:'\@';
            border-right: 0.5pt white solid;
            text-align: center;
        }
        
        table.main tbody tr td.centered
        {
            text-align: center;
        }
        
        <!-- Légende -->
        .legend-title
        {
            color: #000080;
            font-weight: bold;
            padding-bottom: 3.0pt;
            font-size: 8.0pt;
        }
        
        <!-- Autres styles -->
        .codeAmetys 
        { 
            color: #777777;
        }
        
        .size-8
        {
            font-size: 8.0pt;
        }
        
        
        span.lang
        {
            font-weight: normal;
        }
        
        span.remarques
        {
            font-weight: normal;
            color: #777777;
        }
    </xsl:template>
    
    <xsl:template name="table-head">
        <xsl:apply-templates select="program|subProgram|container" mode="title" />
        <xsl:call-template name="table-header"/>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:apply-templates select="program|subProgram|container" mode="document-content" />
        <xsl:call-template name="legende" />
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="title">
         <tr><td colspan="{$nbColumns}" class="main-title1"><xsl:value-of select="su:sanitizeXlsHtml(title)"/></td></tr>
        <xsl:call-template name="catalog-title"/>
        <xsl:if test="/report/path">
            <tr><td colspan="{$nbColumns}" class="main-title3"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_INCLUDES"/></td></tr>
            <xsl:for-each select="/report/path">
                <tr><td colspan="{$nbColumns}" class="main-title3">&#x2022; <xsl:value-of select="."/></td></tr>
            </xsl:for-each>
        </xsl:if>
        <xsl:apply-templates select="." mode="section-header-line"/>
        <tr class="new-header"><td colspan="{$nbColumns}">&#160;</td></tr>
    </xsl:template>
    
    <xsl:template name="catalog-title">
        <tr><td colspan="{$nbColumns}" class="main-title1"><xsl:apply-templates select="." mode="catalog"/></td></tr>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="catalog">
        <xsl:value-of select="/report/catalog"/>
    </xsl:template>
    
    <xsl:template name="section-header">
        <xsl:apply-templates select="ancestor-or-self::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container']" mode="section-header-line"/>
        <tr class="new-header"><td colspan="{$nbColumns}">&#160;</td></tr>
    </xsl:template>
    
    <xsl:template match="program" mode="section-header-line">
        <xsl:apply-templates select="." mode="section-header-line-title"/>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value" select="ects/@title"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DEGREE'"/>
            <xsl:with-param name="value" select="su:sanitizeXlsHtml(degree/@title)"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_MENTION'"/>
            <xsl:with-param name="value" select="su:sanitizeXlsHtml(mention/@title)"/>
        </xsl:call-template>
        <xsl:variable name="domains">
            <xsl:for-each select="domain">
                <xsl:value-of select="su:sanitizeXlsHtml(@title)"/>
                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_DOMAIN'"/>
            <xsl:with-param name="value" select="$domains"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_SPECIALITY'"/>
            <xsl:with-param name="value" select="speciality"/>
        </xsl:call-template>
        <xsl:apply-templates select="knowledgeCheck"/>
    </xsl:template>
    
    <xsl:template match="subProgram" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <xsl:apply-templates select="." mode="section-header-line-title">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value" select="ects/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:apply-templates select="knowledgeCheck">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="container" mode="section-header-line">
        <xsl:variable name="padding" select="count(ancestor::*[parent::program or parent::subProgram or parent::container][local-name() = 'subProgram' or local-name() = 'container'])*4" />
        
        <xsl:apply-templates select="." mode="section-header-line-title">
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:apply-templates>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ECTS'"/>
            <xsl:with-param name="value">
                <xsl:call-template name="display-double">
                    <xsl:with-param name="value" select="ects" />
                    <xsl:with-param name="showZero" select="false()" />
                </xsl:call-template>
            </xsl:with-param>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NATURE'"/>
            <xsl:with-param name="value" select="nature/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_PERIOD'"/>
            <xsl:with-param name="value" select="period/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_COMPENSABLE'"/>
            <xsl:with-param name="value" select="mccCompensable"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_JUSTIF'"/>
            <xsl:with-param name="value" select="justifiedAbsence"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_ABS_INJUSTIF'"/>
            <xsl:with-param name="value" select="unjustifiedAbsence"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_REGIME'"/>
            <xsl:with-param name="value" select="mccRegime/@title"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:call-template name="label-value">
            <xsl:with-param name="i18nLabelKey" select="'PLUGINS_ODF_PILOTAGE_MCC_HEADER_NB_SESSIONS'"/>
            <xsl:with-param name="value" select="mccNbSessions"/>
            <xsl:with-param name="padding" select="$padding"/>
        </xsl:call-template>
        <xsl:if test="mcc_workflow/mcc_orgunit_validation_date != ''">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_ORGUNIT"/></strong>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                    <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/mcc_orgunit_validation_date"/></i18n:date>
                </td>
            </tr>
            <xsl:if test="mcc_workflow/mcc_orgunit_validation_comment != ''">
                <tr>
                    <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                        <xsl:call-template name="text.nl2hyphen">  
                            <xsl:with-param name="input" select="mcc_workflow/mcc_orgunit_validation_comment"/>
                        </xsl:call-template>
                    </td>
                </tr>
            </xsl:if>
            <xsl:if test="mcc_workflow/cfvu_mcc_validation_date != ''">
                <tr>
                    <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_HEADER_VALIDATION_DATE_CFVU"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                        <i18n:date src-pattern="yyyy-MM-dd" pattern="long"><xsl:value-of select="mcc_workflow/cfvu_mcc_validation_date"/></i18n:date>
                    </td>
                </tr>
                <xsl:if test="mcc_workflow/cfvu_mcc_validation_comment != ''">
                    <tr>
                        <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                            <xsl:call-template name="text.nl2hyphen">  
                                <xsl:with-param name="input" select="mcc_workflow/cfvu_mcc_validation_comment"/>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:if>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="section-header-line-title">
        <xsl:param name="padding" select="0"/>
        
        <tr class="new-header">
            <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                <strong><xsl:value-of select="su:sanitizeXlsHtml(title)"/></strong>
                <xsl:apply-templates select="." mode="code-parenthesis"/>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-header">
        <tr>
            <td class="maquette" colspan="{$nbColumnsMaquette}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MAQUETTE"/></td>
            <td class="evaluation" colspan="{$nbColumnsElpEval + $nbColumnsMccSession1 + $nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATION"/></td>
        </tr>
        <tr>
            <xsl:call-template name="table-header-maquette"/>
            <xsl:call-template name="table-header-evaluation-elp"/>
            <td class="session1" colspan="{$nbColumnsMccSession1}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_1"/></td>
            <td class="session2" colspan="{$nbColumnsMccSession2}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_2"/></td>
        </tr>
        <tr>
            <xsl:call-template name="table-header-session1"/>
            <xsl:call-template name="table-header-session2"/>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-header-maquette">
        <td class="maquette" style="width: 10mm" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_EVALUATED"/></td>
        <td class="maquette" style="width: 20mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_CODE"/></td>
        <td class="maquette" style="width: 15mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NATURE"/></td>
        <td class="maquette" style="width: 85mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_LABEL"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_SHARED"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_ECTS"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_COEF"/></td>
        <td class="maquette" style="width: 10mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_NOTE_ELIM"/></td>
        <td class="maquette" style="width: 15mm;" rowspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_REGIME"/></td>
        <td class="maquette" style="width: 20mm;" rowspan="2" colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_VOLUME_HORAIRE"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-evaluation-elp"/>
    
    <xsl:template name="table-header-session1">
        <td class="session1" style="width: 70mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session1" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
        <td class="session1" style="width: 10mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_REPORT_SESSION_2"/></td>
    </xsl:template>
    
    <xsl:template name="table-header-session2">
        <td class="session2" style="width: 70mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LABEL"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_MODALITE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NATURE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_DUREE"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_COEF"/></td>
        <td class="session2" style="width: 15mm;"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_NOTE_ELIM"/></td>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container" mode="document-content">
        <xsl:apply-templates select="subProgram|container|courseList"/>
    </xsl:template>
    
    <xsl:template match="program|subProgram|container">
        <xsl:if test="courseList/course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="courseList[course]"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:apply-templates select="subProgram|container" />
    </xsl:template>
    
    <xsl:template match="courseList">
        <xsl:if test="course">
            <xsl:call-template name="mcc-table">
                <xsl:with-param name="courseLists" select="."/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-table">
        <xsl:param name="courseLists"/>
        
        <xsl:if test="$courseLists/course">
            <xsl:variable name="displayMcc2" select="count($courseLists//course[@session2 = 'available']) > 0"/>
            
            <xsl:call-template name="section-header"/>
            <xsl:apply-templates select="$courseLists" mode="table-content">
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:apply-templates>
            <xsl:apply-templates select="controles" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="courseList" mode="table-content">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" />
        
        <xsl:variable name="courseListChoice" select="choiceType/@value"/>
        <xsl:choose>
            <xsl:when test="$courseListChoice = 'CHOICE'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:translate>
                            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_CHOICE"/>
                            <i18n:param><xsl:value-of select="min" /></i18n:param>
                        </i18n:translate>
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="$courseListChoice = 'OPTIONAL'">
                <tr class="courselist">
                    <td colspan="{$titleColumnPosition - 1}" class="first-cell"/>
                    <td colspan="{$nbColumns - $titleColumnPosition + 1 - $nbColumnsMccSession2 * not($displayMcc2)}">
                        <xsl:call-template name="recursive-print">
                            <xsl:with-param name="times" select="$depth" />
                        </xsl:call-template>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COURSELIST_OPTIONAL"/>
                    </td>
                </tr>
            </xsl:when>
        </xsl:choose>
        
        <xsl:apply-templates select="course">
            <xsl:with-param name="depth" select="$depth + ($courseListChoice != 'MANDATORY')"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="displayMcc2" select="true()"/>
        
        <xsl:variable name="currentCourse" select="."/>
        <xsl:variable name="courseParts">
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="code">
                        <xsl:call-template name="displayCodeOrShortLabel">
                            <xsl:with-param name="contentId" select="@id"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="volumeHoraire" select="$currentCourse/courseParts[nature/@id = current()/@id]/nbHours"/>
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[natureEnseignement/@id = current()/@id]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:for-each>
            
            <!-- Ajouter les lignes sans nature d'enseignement -->
            <xsl:if test="$currentCourse/mcc/*/entry[not(natureEnseignement/@id)]">
                <xsl:call-template name="enseignement-cells">
                    <xsl:with-param name="mcc1" select="$currentCourse/mcc/mccSession1/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="mcc2" select="$currentCourse[@session2 = 'available']/mcc/mccSession2/entry[not(natureEnseignement/@id)]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="exsl:node-set($courseParts)/row">
                <xsl:for-each select="exsl:node-set($courseParts)/row">
                    <xsl:choose>
                        <xsl:when test="position() = 1">
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                </xsl:call-template>
                                
                                <xsl:apply-templates select="$currentCourse" mode="cells">
                                    <xsl:with-param name="depth" select="$depth"/>
                                    <xsl:with-param name="rowspan" select="count(exsl:node-set($courseParts)/row)"/>
                                </xsl:apply-templates>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:when>
                        <xsl:otherwise>
                            <tr>
                                <xsl:call-template name="course-attributes">
                                    <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                                    <xsl:with-param name="isFirst" select="false()"/>
                                </xsl:call-template>
                                
                                <xsl:copy-of select="*"/>
                            </tr>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <xsl:call-template name="course-attributes">
                        <xsl:with-param name="type" select="$currentCourse/courseType/code"/>
                    </xsl:call-template>
                    
                    <xsl:apply-templates select="." mode="cells">
                        <xsl:with-param name="depth" select="$depth"/>
                    </xsl:apply-templates>
                    
                    <xsl:call-template name="mcc-empty-cells">
                        <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                    </xsl:call-template>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        
        <xsl:apply-templates select="courseList[course]" mode="table-content">
            <xsl:with-param name="depth" select="$depth + 1"/>
            <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="enseignement-cells">
        <xsl:param name="code"/>
        <xsl:param name="volumeHoraire" select="foo/*"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:variable name="countMCC1" select="count($mcc1)"/>
        <xsl:variable name="countMCC2" select="count($mcc2) * $displayMcc2"/>
        
        <xsl:variable name="mccLines">
            <xsl:choose>
                <xsl:when test="$countMCC1 > $countMCC2"><xsl:value-of select="$countMCC1"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$countMCC2"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:if test="count($volumeHoraire) > 0 or $mccLines > 0">
            <xsl:variable name="rowspan">
                <xsl:choose>
                    <xsl:when test="$countMCC1 = 0 and $countMCC2 = 0">1</xsl:when>
                    <xsl:otherwise><xsl:value-of select="$mccLines"/></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <row>
                <td class="nature-ens" rowspan="{$rowspan}">
                    <xsl:value-of select="$code"/>
                </td>
                <td rowspan="{$rowspan}">
                    <xsl:if test="$code or count($volumeHoraire) > 0">
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="sum($volumeHoraire)"/>
                        </xsl:call-template>
                    </xsl:if>
                </td>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[1]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[1]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            <xsl:if test="$mccLines > 1">
                <xsl:call-template name="mcc-recursive-row">
                    <xsl:with-param name="currentPosition" select="2"/>
                    <xsl:with-param name="maxPosition" select="$mccLines"/>
                    <xsl:with-param name="mcc1" select="$mcc1"/>
                    <xsl:with-param name="mcc2" select="$mcc2"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-recursive-row">
        <xsl:param name="currentPosition"/>
        <xsl:param name="maxPosition"/>
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <xsl:if test="$currentPosition &lt;= $maxPosition">
            <row>
                <xsl:call-template name="mcc">
                    <xsl:with-param name="mcc1" select="$mcc1[position() = $currentPosition]"/>
                    <xsl:with-param name="mcc2" select="$mcc2[position() = $currentPosition]"/>
                    <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
                </xsl:call-template>
            </row>
            <xsl:call-template name="mcc-recursive-row">
                <xsl:with-param name="currentPosition" select="$currentPosition + 1"/>
                <xsl:with-param name="maxPosition" select="$maxPosition"/>
                <xsl:with-param name="mcc1" select="$mcc1"/>
                <xsl:with-param name="mcc2" select="$mcc2"/>
                <xsl:with-param name="displayMcc2" select="$displayMcc2"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="mcc">
        <xsl:param name="mcc1"/>
        <xsl:param name="mcc2"/>
        <xsl:param name="displayMcc2"/>
        
        <!-- session 1 -->
        <xsl:call-template name="mcc-session-cells-1">
            <xsl:with-param name="entry" select="$mcc1" />
        </xsl:call-template>
        
        <!-- session 2 -->
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-cells-2">
                <xsl:with-param name="entry" select="$mcc2" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-1">
        <xsl:param name="entry" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-1"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-1" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="mcc-session-cells-2">
        <xsl:param name="entry" />
        
        <xsl:choose>
            <xsl:when test="$entry">
                <xsl:apply-templates select="$entry" mode="mcc-session-cells-non-empty-2"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="mcc-session-empty-cells-2" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="entry" mode="suffix"/>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-1">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
            <xsl:with-param name="isLast" select="false()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-report">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="mcc-session-cells-non-empty-2">
        <xsl:variable name="suffix">
            <xsl:apply-templates select="." mode="suffix"/>
        </xsl:variable>
        
        <xsl:apply-templates select="." mode="cell-session-label">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-modalite">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-nature">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-duree">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-coef">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-session-note">
            <xsl:with-param name="suffix" select="$suffix"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-label">
        <xsl:param name="suffix"/>
        
        <td class="session-cell{$suffix}">
            <xsl:if test="label != ''">
                <strong><xsl:value-of select="label"/></strong>
            </xsl:if>
            <xsl:if test="foreignLanguage/@id">
                <xsl:if test="label != ''"><xsl:text> - </xsl:text></xsl:if>
                <span class="lang">
                    <xsl:if test="foreignLanguage/@id">
                        <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_COL_MCC_SESSION_LANG"/></strong>
                        <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                        <xsl:value-of select="foreignLanguage/@title"/>
                    </xsl:if>
                </span>
            </xsl:if>
            <xsl:if test="remarques != ''">
                <xsl:if test="label != '' or foreignLanguage/@id"><xsl:text> - </xsl:text></xsl:if>
                <span class="remarques">
                    <xsl:call-template name="text.nl2hyphen">  
                        <xsl:with-param name="input" select="remarques"/>
                    </xsl:call-template>
                </span>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-modalite">
        <xsl:param name="suffix"/>
        
        <td class="session-cell-centered{$suffix}">
            <xsl:if test="nombre != ''">
                <xsl:value-of select="nombre" />
                <xsl:if test="modalite/@id">
                    <xsl:text> </xsl:text>
                </xsl:if>
            </xsl:if>
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="modalite/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-nature">
        <xsl:param name="suffix"/>
        
        <td class="session-cell-centered{$suffix}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="nature/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-duree">
        <xsl:param name="suffix"/>
        
        <td class="session-cell-centered{$suffix}">
            <xsl:if test="duree != ''"><xsl:value-of select="odf:minute2hour(duree)" /></xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-coef">
        <xsl:param name="suffix"/>
        
        <td class="session-cell-coef{$suffix}">
            <xsl:if test="coefficient != ''">
                <xsl:choose>
                    <xsl:when test="contains(coefficient, '%') or contains(coefficient, '/')">
                        <xsl:value-of select="coefficient"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="coefficient" />
                            <xsl:with-param name="showZero" select="true()" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-note">
        <xsl:param name="suffix"/>
        <xsl:param name="isLast" select="true()"/>
        
        <td>
            <xsl:attribute name="class"><xsl:if test="not($isLast)">session-cell-</xsl:if>centered<xsl:value-of select="$suffix"/></xsl:attribute>
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="noteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="entry" mode="cell-session-report">
        <xsl:param name="suffix"/>
        
        <td class="centered{$suffix}">
            <xsl:if test="reportSession2 = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cells">
        <xsl:param name="depth" select="'0'" />
        <xsl:param name="rowspan" select="1"/>
        
        <xsl:apply-templates select="." mode="cell-course-evaluated">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-code">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-nature">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-label">
            <xsl:with-param name="rowspan" select="$rowspan"/>
            <xsl:with-param name="depth" select="$depth"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-shared">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-ects">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-coef">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-note">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="." mode="cell-course-regime">
            <xsl:with-param name="rowspan" select="$rowspan"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-evaluated">
        <xsl:param name="rowspan"/>
        <td class="first-cell" rowspan="{$rowspan}">
            <xsl:if test="not(isEvaluated) or isEvaluated = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-code">
        <xsl:param name="rowspan"/>
        <td class="codeAmetys" rowspan="{$rowspan}">
            <xsl:apply-templates select="." mode="code"/>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-nature">
        <xsl:param name="rowspan"/>
        <td rowspan="{$rowspan}">
            <xsl:value-of select="courseType/code" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-label">
        <xsl:param name="rowspan"/>
        <xsl:param name="depth"/>
        <td rowspan="{$rowspan}">
            <!-- Identation. Print 4 spaces per level -->
            <xsl:call-template name="recursive-print">
                <xsl:with-param name="times" select="$depth" />
            </xsl:call-template>
            <xsl:value-of select="su:sanitizeXlsHtml(title)" />
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-shared">
        <xsl:param name="rowspan"/>
        <td class="centered" rowspan="{$rowspan}">
            <xsl:if test="isShared = 'true'">X</xsl:if>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-ects">
        <xsl:param name="rowspan"/>
        <td class="centered" rowspan="{$rowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="odf:getEcts(@id, @path)" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-coef">
        <xsl:param name="rowspan"/>
        <td class="centered" rowspan="{$rowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="mccCoefficient" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-regime">
        <xsl:param name="rowspan"/>
        <td rowspan="{$rowspan}">
            <xsl:call-template name="displayCodeOrShortLabel">
                <xsl:with-param name="contentId" select="mccRegime/@id"/>
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template match="course" mode="cell-course-note">
        <xsl:param name="rowspan"/>
        <td rowspan="{$rowspan}">
            <xsl:call-template name="display-double">
                <xsl:with-param name="value" select="mccNoteEliminatoire" />
                <xsl:with-param name="showZero" select="true()" />
            </xsl:call-template>
        </td>
    </xsl:template>
    
    <xsl:template name="mcc-empty-cells">
        <xsl:param name="displayMcc2" />
        
        <xsl:call-template name="volume-horaire-empty-cells" />
        <xsl:call-template name="mcc-session-empty-cells-1" />
        <xsl:if test="$displayMcc2">
            <xsl:call-template name="mcc-session-empty-cells-2" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="volume-horaire-empty-cells">
        <td colspan="2"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-1">
        <td colspan="{$nbColumnsMccSession1}"/>
    </xsl:template>
    
    <xsl:template name="mcc-session-empty-cells-2">
        <td colspan="{$nbColumnsMccSession2}"/>
    </xsl:template>
    
    <xsl:template match="knowledgeCheck|controles">
        <xsl:param name="padding" select="0"/>
        
        <xsl:if test="cms:isNotRichTextEmpty(.)">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <xsl:apply-templates select="docbook:article">
                        <xsl:with-param name="level" select="3"/>
                    </xsl:apply-templates>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="course-attributes">
        <xsl:param name="type"/>
        <xsl:param name="isFirst" select="true()"/>
        
        <xsl:attribute name="class">
            <xsl:choose>
                <xsl:when test="$type='UE'"><xsl:if test="$isFirst">first-</xsl:if>ue</xsl:when>
                <xsl:otherwise>elp</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template name="label-value">
        <xsl:param name="i18nLabelKey"/>
        <xsl:param name="value"/>
        <xsl:param name="padding" select="0"/>
        
        <xsl:if test="$value != ''">
            <tr>
                <td colspan="{$nbColumns}" style="padding-left: {$padding}mm;">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="{$i18nLabelKey}"/></strong>
                    <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_MCC_LABEL_VALUE_SEPARATOR"/>
                    <xsl:value-of select="$value"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
