/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

/**
 * This class store informations about the norm
 */
public class NormDetails
{
    /** Norm label */
    private String _label;
    
    /** Effective max */
    private Long _effectiveMax;
    
    /** Effective min sup */
    private Long _effectiveMinSup;

    /**
     * The constructor
     * @param effMax the effective max
     * @param effMinSup the effective min sup
     */
    public NormDetails(Long effMax, Long effMinSup)
    {
        this(effMax, effMinSup, StringUtils.EMPTY);
    }
    
    /**
     * The constructor
     * @param effMax the effective max
     * @param effMinSup the effective min sup
     * @param label the norm label
     */
    public NormDetails(Long effMax, Long effMinSup, String label)
    {
        _effectiveMax = effMax;
        _effectiveMinSup = effMinSup;
        _label = label;
    }

    /**
     * Get the effective min sup
     * @return the effective min sup
     */
    public Long getEffectiveMinSup()
    {
        return _effectiveMinSup;
    }

    /**
     * Get the effective min sup or if <code>null</code> the default value 1
     * @return the effective min sup
     */
    public Long getEffectiveMinSupOrDefault()
    {
        return Optional.ofNullable(_effectiveMinSup).orElse(1L);
    }

    /**
     * Get the effective max
     * @return the effective max
     */
    public Long getEffectiveMax()
    {
        return _effectiveMax;
    } 

    /**
     * Get the effective min sup or if <code>null</code> the default value 1
     * @return the effective min sup
     */
    public Long getEffectiveMaxOrDefault()
    {
        return Optional.ofNullable(_effectiveMax).orElse(Long.MAX_VALUE);
    }
    
    /**
     * Get the norm label
     * @return the norm label
     */
    public String getNormLabel()
    {
        return _label;
    } 
}
