/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.enumerators;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * The number of sessions enumerator: 1 or 2.
 */
public class NbSessionsEnumerator implements Enumerator<String>, org.ametys.runtime.parameter.Enumerator
{
    /**
     * Values of session enumerator
     */
    public enum Value
    {
        /** One MCC session */
        ONE_SESSION(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_TS_RESTRICTIONS_NB_SESSIONS_ENUM_ONE_SESSION")),
        /** Two MCC sessions */
        TWO_SESSIONS(new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_TS_RESTRICTIONS_NB_SESSIONS_ENUM_TWO_SESSIONS"));

        private I18nizableText _label;

        private Value(I18nizableText label)
        {
            this._label = label;
        }
        
        /**
         * Get the label.
         * @return The label
         */
        public I18nizableText getLabel()
        {
            return _label;
        }
    }
    
    private static final Map<String, I18nizableText> __NB_SESSIONS;
    static
    {
        __NB_SESSIONS = Stream.of(Value.values())
            .collect(Collectors.toMap(Value::name, Value::getLabel, (a, b) -> b, LinkedHashMap::new));
    }
    
    public I18nizableText getEntry(String value) throws Exception
    {
        return __NB_SESSIONS.get(value);
    }
    public Map<String, I18nizableText> getTypedEntries() throws Exception
    {
        return __NB_SESSIONS;
    }
    
    @SuppressWarnings("unchecked")
    public Map<Object, I18nizableText> getEntries() throws Exception
    {
        return (Map<Object, I18nizableText>) (Object) getTypedEntries();
    }
    
    @Override
    // TODO NEWATTRIBUTEAPI: remove this method when org.ametys.runtime.parameter.Enumerator will be removed
    public Map<String, Object> getConfiguration()
    {
        return Collections.EMPTY_MAP;
    }
}
