/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.cms.contenttype.MetadataType;
import org.ametys.cms.search.query.NotQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.Query.Operator;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.ui.model.impl.AbstractCustomSearchUICriterion;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;

/**
 * UI criteria for filter on compatible regimes
 */
public class CompatibleRegimesSearchUICriteria extends AbstractCustomSearchUICriterion
{
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        
        // Hidden criteria
        setHidden(true);
    }

    public Operator getOperator()
    {
        return Operator.EXISTS;
    }
    
    public String getFieldId()
    {
        return getId();
    }
    
    @Override
    public MetadataType getType()
    {
        // Not suppose to be used
        return MetadataType.STRING;
    }
    
    public Query getQuery(Object value, Operator customOperator, Map<String, Object> allValues, String language, Map<String, Object> contextualParameters)
    {
        List<Query> queries = new ArrayList<>();
        
        if (allValues.containsKey(PilotageHelper.COMPATIBLE_REGIMES_ATTRIBUTE_NAME))
        {
            String filteredRegime = (String) allValues.get(PilotageHelper.COMPATIBLE_REGIMES_ATTRIBUTE_NAME);
            queries.add(new StringQuery(PilotageHelper.COMPATIBLE_REGIMES_ATTRIBUTE_NAME, filteredRegime));
            queries.add(new NotQuery(new StringQuery(PilotageHelper.COMPATIBLE_REGIMES_ATTRIBUTE_NAME)));
        }
        
        return new OrQuery(queries);
    }
}
