/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.ametys.cms.clientsideelement.SmartContentClientSideElement;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.odf.program.Container;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowException;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.odfpilotage.schedulable.MCCValidatedPDFSchedulable;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.SchedulerException;

public class MCCWorkflowClientSideElement
extends SmartContentClientSideElement {
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected PilotageHelper _pilotageHelper;
    protected Scheduler _scheduler;
    protected SchedulableExtensionPoint _schedulerEP;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
        this._schedulerEP = (SchedulableExtensionPoint)manager.lookup(SchedulableExtensionPoint.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        MCCWorkflowHelper.MCCWorkflowStep mccStatus;
        List scripts = super.getScripts(ignoreRights, contextParameters);
        if (!scripts.isEmpty() && MCCWorkflowHelper.MCCWorkflowStep.RULES_VALIDATED.equals((Object)(mccStatus = MCCWorkflowHelper.MCCWorkflowStep.valueOf((String)((ClientSideElement.Script)scripts.get(0)).getParameters().get("mcc-status")))) && !RulesManager.isRulesEnabled()) {
            return List.of();
        }
        return scripts;
    }

    @Callable
    public Map<String, Object> getStatus(List<String> containerIds, String mccStatus) {
        Map results = super.getStatus(containerIds);
        results.put("active-contents", new ArrayList());
        results.put("invalidmccstatus-contents", new ArrayList());
        results.put("noyear-contents", new ArrayList());
        List activeContents = (List)results.get("active-contents");
        List invalidContents = (List)results.get("invalidmccstatus-contents");
        List noYearContents = (List)results.get("noyear-contents");
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            this._getStatus(container, mccStatus, activeContents, noYearContents, invalidContents);
        }
        List<Object> invalidContentIds = invalidContents.stream().map(p -> p.get("id")).toList();
        List<Object> noYearContentIds = noYearContents.stream().map(p -> p.get("id")).toList();
        List allrightContents = (List)results.get("allright-contents");
        results.put("allright-contents", allrightContents.stream().filter(p -> !invalidContentIds.contains(p.get("id")) && !noYearContentIds.contains(p.get("id"))).toList());
        return results;
    }

    protected void _getStatus(Container container, String mccStatus, List<Map<String, Object>> activeContents, List<Map<String, Object>> noYearContents, List<Map<String, Object>> invalidMCCStatusContents) {
        Map defaultContentParams = this.getContentDefaultParameters((Content)container);
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            HashMap<String, I18nizableText> noYearContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
            noYearContentParams.put("description", this._getNoYearDescription((Content)container));
            noYearContents.add(noYearContentParams);
            return;
        }
        switch (MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus)) {
            case RULES_VALIDATED: {
                if (this._mccWorkflowHelper.isRulesValidated(container)) {
                    HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                    activeContentParams.put("description", this._getActiveDescription((Content)container));
                    activeContents.add(activeContentParams);
                }
                if (!this._mccWorkflowHelper.isMCCOrgunitValidated(container) && this._mccWorkflowHelper.canValidateRules(container)) break;
                HashMap<String, I18nizableText> invalidContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                invalidContentParams.put("description", this._getInvalidMCCStatusDescription((Content)container));
                invalidMCCStatusContents.add(invalidContentParams);
                break;
            }
            case MCC_VALIDATED: {
                if (this._mccWorkflowHelper.isMCCValidated(container)) {
                    HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                    activeContentParams.put("description", this._getActiveDescription((Content)container));
                    activeContents.add(activeContentParams);
                }
                if (!this._mccWorkflowHelper.isMCCOrgunitValidated(container) && this._mccWorkflowHelper.canValidateMCC(container)) break;
                HashMap<String, I18nizableText> invalidContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                invalidContentParams.put("description", this._getInvalidMCCStatusDescription((Content)container));
                invalidMCCStatusContents.add(invalidContentParams);
                break;
            }
            case MCC_ORGUNIT_VALIDATED: {
                if (this._mccWorkflowHelper.isMCCOrgunitValidated(container)) {
                    HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                    activeContentParams.put("description", this._getActiveDescription((Content)container));
                    activeContents.add(activeContentParams);
                }
                if (!this._mccWorkflowHelper.isMCCCFVUValidated(container) && this._mccWorkflowHelper.canValidateOrgUnitMCC(container)) break;
                HashMap<String, I18nizableText> invalidContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                invalidContentParams.put("description", this._getInvalidMCCStatusDescription((Content)container));
                invalidMCCStatusContents.add(invalidContentParams);
                break;
            }
            case CFVU_MCC_VALIDATED: {
                if (this._mccWorkflowHelper.isMCCCFVUValidated(container)) {
                    HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                    activeContentParams.put("description", this._getActiveDescription((Content)container));
                    activeContents.add(activeContentParams);
                }
                if (this._mccWorkflowHelper.canValidateCFVUMCC(container)) break;
                HashMap<String, I18nizableText> invalidContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                invalidContentParams.put("description", this._getInvalidMCCStatusDescription((Content)container));
                invalidMCCStatusContents.add(invalidContentParams);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for MCC status : " + mccStatus);
            }
        }
    }

    protected I18nizableText _getActiveDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("active-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getInvalidMCCStatusDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("invalidmccstatus-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    protected I18nizableText _getNoYearDescription(Content content) {
        ArrayList<String> workflowI18nParameters = new ArrayList<String>();
        workflowI18nParameters.add(this._contentHelper.getTitle(content));
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("noyear-content-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), workflowI18nParameters);
    }

    @Callable(rights={""})
    public Map<String, Object> validateRules(List<String> containerIds, String validationDate, String comment) {
        UserIdentity user = this._currentUserProvider.getUser();
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime((String)validationDate).withZoneSameInstant(ZoneId.systemDefault());
        LocalDate localDate = zonedDateTime != null ? zonedDateTime.toLocalDate() : LocalDate.now();
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Rules_Validated_Rights", container -> this._mccWorkflowHelper.validateRules((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> invalidateRules(List<String> containerIds) {
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Rules_Validated_Rights", container -> this._mccWorkflowHelper.invalidateRules((Container)container));
    }

    @Callable(rights={""})
    public Map<String, Object> validateMCC(List<String> containerIds, String validationDate, String comment) {
        UserIdentity user = this._currentUserProvider.getUser();
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime((String)validationDate).withZoneSameInstant(ZoneId.systemDefault());
        LocalDate localDate = zonedDateTime != null ? zonedDateTime.toLocalDate() : LocalDate.now();
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Validated_Rights", container -> this._mccWorkflowHelper.validateMCC((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> invalidateMCC(List<String> containerIds) {
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Validated_Rights", container -> this._mccWorkflowHelper.invalidateMCC((Container)container));
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCOrgUnitValidation(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_MCC_Orgunit_Validated_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCOrgUnitValidation(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public Map<String, Object> validateOrgunitMCC(List<String> containerIds, String validationDate, String comment) {
        UserIdentity user = this._currentUserProvider.getUser();
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime((String)validationDate).withZoneSameInstant(ZoneId.systemDefault());
        LocalDate localDate = zonedDateTime != null ? zonedDateTime.toLocalDate() : LocalDate.now();
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Orgunit_Validated_Rights", container -> this._mccWorkflowHelper.validateOrgunitMCC((Container)container, localDate, user, comment));
    }

    @Callable(rights={""})
    public Map<String, Object> invalidateOrgunitMCC(List<String> containerIds) {
        return this._doMCCAction(containerIds, "ODF_Pilotage_MCC_Orgunit_Validated_Rights", container -> this._mccWorkflowHelper.invalidateOrgunitMCC((Container)container));
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCCFVUValidation(List<String> containerIds) {
        UserIdentity user = this._currentUserProvider.getUser();
        LocalDate minDate = null;
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            if (this._rightManager.hasRight(user, "ODF_Pilotage_CFVU_MCC_Validated_Rights", (Object)container) != RightManager.RightResult.RIGHT_ALLOW) continue;
            LocalDate cMinDate = this._mccWorkflowHelper.getMinDateForMCCCFVUValidation(container);
            if (minDate != null && !cMinDate.isAfter(minDate)) continue;
            minDate = cMinDate;
        }
        return minDate;
    }

    @Callable(rights={""})
    public Map<String, Object> validateMCCForCVFU(List<String> containerIds, String validationDate, String comment, Map<String, Object> contextualParameters) {
        UserIdentity user = this._currentUserProvider.getUser();
        ZonedDateTime zonedDateTime = DateUtils.parseZonedDateTime((String)validationDate).withZoneSameInstant(ZoneId.systemDefault());
        LocalDate localDate = zonedDateTime != null ? zonedDateTime.toLocalDate() : LocalDate.now();
        Map<String, Object> results = this._doMCCAction(containerIds, "ODF_Pilotage_CFVU_MCC_Validated_Rights", container -> this._mccWorkflowHelper.validateMCCForCVFU((Container)container, localDate, user, comment));
        try {
            List successContentIds = (List)results.get("success-contents");
            if (!successContentIds.isEmpty()) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("date", localDate);
                parameters.put("containerIds", successContentIds);
                parameters.put("contextualParameters", this._jsonUtils.convertObjectToJson(contextualParameters));
                Schedulable mccValidatedPDFSchedulable = (Schedulable)this._schedulerEP.getExtension(MCCValidatedPDFSchedulable.ID);
                String runnableId = mccValidatedPDFSchedulable.getId() + "$" + UUID.randomUUID();
                DefaultRunnable runnable = new DefaultRunnable(runnableId, mccValidatedPDFSchedulable.getLabel(), mccValidatedPDFSchedulable.getDescription(), Runnable.FireProcess.NOW, null, mccValidatedPDFSchedulable.getId(), true, false, false, Runnable.MisfirePolicy.FIRE_ONCE, true, this._currentUserProvider.getUser(), parameters);
                this._scheduler.scheduleJob((Runnable)runnable);
                results.put("schedulable-id", runnableId);
                results.put("schedulable-label", mccValidatedPDFSchedulable.getLabel());
            }
        }
        catch (SchedulerException e) {
            results.put("error", "schedulable-error");
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> invalidateMCCForCVFU(List<String> containerIds) {
        return this._doMCCAction(containerIds, "ODF_Pilotage_CFVU_MCC_Validated_Rights", container -> this._mccWorkflowHelper.invalidateMCCForCVFU((Container)container));
    }

    private Map<String, Object> _doMCCAction(List<String> containerIds, String rightId, Function<Container, Boolean> mccWorkflowAction) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Map<String, String>> noRightContents = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> lockedContents = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> workflowErrorContents = new ArrayList<Map<String, String>>();
        ArrayList<String> successContents = new ArrayList<String>();
        UserIdentity user = this._currentUserProvider.getUser();
        for (String containerId : containerIds) {
            Container container = (Container)this._resolver.resolveById(containerId);
            try {
                if (this._rightManager.hasRight(user, rightId, (Object)container) != RightManager.RightResult.RIGHT_ALLOW) {
                    noRightContents.add(Map.of("id", containerId, "title", container.getTitle()));
                    continue;
                }
                if (container.isLocked() && !LockHelper.isLockOwner((LockAwareAmetysObject)container, (UserIdentity)user)) {
                    lockedContents.add(Map.of("id", containerId, "title", container.getTitle()));
                    continue;
                }
                mccWorkflowAction.apply(container);
                successContents.add(containerId);
            }
            catch (MCCWorkflowException e) {
                workflowErrorContents.add(Map.of("id", containerId, "title", container.getTitle(), "errorType", e.getType().name()));
            }
        }
        results.put("success-contents", successContents);
        results.put("noright-contents", noRightContents);
        results.put("locked-contents", lockedContents);
        results.put("invalidmccstatus-contents", workflowErrorContents);
        return results;
    }
}

