/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.observation;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.engine.BackgroundEngineHelper;
import org.ametys.core.engine.BackgroundEnvironment;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Container;
import org.ametys.plugins.core.user.UserDAO;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;

public class MccRegimeObserver
extends AbstractLogEnabled
implements Observer,
Contextualizable,
Serviceable,
Initializable {
    private static final String __ALREADY_EXPLORING = MccRegimeObserver.class.getName() + "$alreadyRunning";
    private static ExecutorService __THREAD_EXECUTOR;
    private boolean _isActive;
    private boolean _force;
    private org.apache.avalon.framework.context.Context _context;
    private Context _environmentContext;
    private ServiceManager _serviceManager;
    private ODFHelper _odfHelper;
    private PilotageHelper _pilotageHelper;
    private ContentWorkflowHelper _contentWorkflowHelper;
    private CurrentUserProvider _currentUserProvider;
    private AmetysObjectResolver _resolver;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._environmentContext = (Context)this._context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._serviceManager = smanager;
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)smanager.lookup(PilotageHelper.ROLE));
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void initialize() throws Exception {
        String regimePolicy = this._pilotageHelper.getMCCRegimePolicy();
        this._force = regimePolicy.equals("FORCE");
        this._isActive = this._force || regimePolicy.equals("DEFAULT");
        __THREAD_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new AsyncWorkflowCallThreadFactory());
    }

    public boolean supports(Event event) {
        if (this._isActive && event.getId().equals("content.modified")) {
            return event.getArguments().get("content") instanceof ProgramItem;
        }
        return false;
    }

    public int getPriority(Event event) {
        return 2000;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        ProgramItem programItem;
        Container stepHolder;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context);
        boolean alreadyExploring = Optional.of(request).map(r -> r.getAttribute(__ALREADY_EXPLORING)).map(v -> (boolean)((Boolean)v)).orElse(false);
        if (!alreadyExploring && (stepHolder = (Container)this._pilotageHelper.getStepHolder(programItem = (ProgramItem)event.getArguments().get("content")).getRight()) != null && stepHolder.hasValue("mccRegime")) {
            this._updateCourses(programItem, stepHolder, (ContentValue)stepHolder.getValue("mccRegime"));
        }
    }

    private void _updateCourses(ProgramItem programItem, Container stepHolder, ContentValue mccRegime) {
        Course course;
        if (programItem instanceof Course && (!(course = (Course)programItem).hasValueOrEmpty("mccRegime") || this._force && !mccRegime.equals(course.getValue("mccRegime"))) && stepHolder.equals(this._pilotageHelper.getStepHolder(programItem).getRight())) {
            course.setValue("mccRegime", (Object)mccRegime);
            course.saveChanges();
            this._callWorkflowAsynchronously(course);
        }
        this._odfHelper.getChildProgramItems(programItem).forEach(child -> this._updateCourses((ProgramItem)child, stepHolder, mccRegime));
    }

    private void _callWorkflowAsynchronously(Course course) {
        __THREAD_EXECUTOR.submit(new UpdateWorkflow(course, this._currentUserProvider.getUser(), (Logger)new SLF4JLoggerAdapter(this.getLogger())));
    }

    static class AsyncWorkflowCallThreadFactory
    implements ThreadFactory {
        private static ThreadFactory _defaultThreadFactory;
        private static String _nameFormat;
        private static AtomicLong _count;

        public AsyncWorkflowCallThreadFactory() {
            _defaultThreadFactory = Executors.defaultThreadFactory();
            _nameFormat = "ametys-async-workflow-call-regime-%d";
            _count = new AtomicLong(0L);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = _defaultThreadFactory.newThread(r);
            thread.setName(String.format(_nameFormat, _count.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    }

    private class UpdateWorkflow
    implements Runnable {
        private String _courseId;
        private UserIdentity _user;
        private Logger _logger;

        public UpdateWorkflow(Course course, UserIdentity user, Logger logger) {
            this._courseId = course.getId();
            this._user = user;
            this._logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map environmentInformation = BackgroundEngineHelper.createAndEnterEngineEnvironment((ServiceManager)MccRegimeObserver.this._serviceManager, (Context)MccRegimeObserver.this._environmentContext, (Logger)this._logger);
            BackgroundEnvironment environment = (BackgroundEnvironment)environmentInformation.get("environment");
            Request request = (Request)environment.getObjectModel().get("request");
            AuthenticateAction.setUserIdentityInSession((Request)request, (UserIdentity)this._user, (CredentialProvider)new UserDAO.ImpersonateCredentialProvider(), (boolean)true);
            request.setAttribute(__ALREADY_EXPLORING, (Object)true);
            try {
                HashMap<String, Object> inputs = new HashMap<String, Object>();
                inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, Map.of("quit", true));
                inputs.put(CheckRightsCondition.FORCE, true);
                Course course = (Course)MccRegimeObserver.this._resolver.resolveById(this._courseId);
                MccRegimeObserver.this._contentWorkflowHelper.doAction((WorkflowAwareContent)course, 2, inputs);
            }
            catch (AmetysRepositoryException e) {
                this._logger.warn("An error occurs while resolving the course " + this._courseId, (Throwable)e);
            }
            catch (InvalidActionException | WorkflowException e) {
                this._logger.warn("An error occurs while updating the course " + this._courseId, e);
            }
            catch (Exception e) {
                this._logger.error("Error occurs during threading process", (Throwable)e);
            }
            finally {
                BackgroundEngineHelper.leaveEngineEnvironment((Map)environmentInformation);
            }
        }
    }
}

