/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.report.impl.mcc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.content.compare.ContentComparatorResult;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.data.EducationalPath;

public class MCCProgramItemTree {
    private MCCProgramItemTree _parent;
    private ProgramItem _current;
    private List<MCCProgramItemTree> _children = new ArrayList<MCCProgramItemTree>();
    private ContentComparatorResult _change;
    private EducationalPath _path;

    private MCCProgramItemTree(MCCProgramItemTree parent, ProgramItem current, ContentComparatorResult change) {
        this._parent = parent;
        this._current = current;
        this._change = change;
    }

    private MCCProgramItemTree(MCCProgramItemTree parent, ProgramItem current) {
        this(parent, current, null);
    }

    public MCCProgramItemTree(ProgramItem current) {
        this(null, current);
    }

    public MCCProgramItemTree(ProgramItem current, ContentComparatorResult change) {
        this(null, current, change);
    }

    public MCCProgramItemTree addChild(ProgramItem child) {
        return this.addChild(child, null);
    }

    public MCCProgramItemTree addChild(ProgramItem child, ContentComparatorResult change) {
        MCCProgramItemTree childTree = this._createChild(child, change);
        this._addChild(childTree);
        return childTree;
    }

    protected void _addChild(MCCProgramItemTree childTree) {
        this._children.add(childTree);
    }

    private MCCProgramItemTree _createChild(ProgramItem child, ContentComparatorResult change) {
        return new MCCProgramItemTree(this, child, change);
    }

    public MCCProgramItemTree getParent() {
        return this._parent;
    }

    public ProgramItem getCurrent() {
        return this._current;
    }

    public List<MCCProgramItemTree> getChildren() {
        return this._children;
    }

    public ContentComparatorResult getChange() {
        return this._change;
    }

    public EducationalPath getPath() {
        if (this._path == null) {
            return Optional.ofNullable(this._parent).map(MCCProgramItemTree::getPath).map(parentPath -> EducationalPath.of((EducationalPath)parentPath, (ProgramItem[])new ProgramItem[]{this._current})).orElseGet(() -> EducationalPath.of((ProgramItem[])new ProgramItem[]{this._current}));
        }
        return this._path;
    }
}

