/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.export.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.RichTextHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.DefaultContent;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ModifiedRulesExportGenerator
extends ServiceableGenerator
implements Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected ThematicsHelper _thematicsHelper;
    protected RichTextHelper _richTextHelper;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._thematicsHelper = (ThematicsHelper)smanager.lookup(ThematicsHelper.ROLE);
        this._richTextHelper = (RichTextHelper)smanager.lookup(RichTextHelper.ROLE);
    }

    public Repository getRepository() {
        return (Repository)this._context.getAttribute("org.ametys.repository.Repository");
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"export");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String type = request.getParameter("type");
        String catalog = request.getParameter("catalog");
        String orgUnit = request.getParameter("orgUnit");
        this._saxHeader(type);
        this._saxRules(catalog, orgUnit, type);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"export");
        this.contentHandler.endDocument();
    }

    protected void _saxHeader(String type) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"header");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_REGIME").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ID_THEMATIC").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_NAME_THEMATIC").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ID_RULE").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ORGUNIT").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ID_CONTAINER").toSAX(this.contentHandler, "column");
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_TITLE_CONTAINER").toSAX(this.contentHandler, "column");
        if ("derogation".equals(type)) {
            new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_DEROGATION").toSAX(this.contentHandler, "column");
        } else if ("complementary".equals(type)) {
            new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_COMPLEMENTARY_RULE").toSAX(this.contentHandler, "column");
        } else {
            new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_ADDITIONAL_RULE").toSAX(this.contentHandler, "column");
        }
        new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_DASHBOARD_EXPORT_CSV_MOTIVATION").toSAX(this.contentHandler, "column");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"header");
    }

    protected void _saxRules(String catalog, String orgUnit, String type) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"rules");
        Map<String, Content> thematics = this._thematicsHelper.getThematics(catalog).collect(Collectors.toMap(c -> (String)c.getValue("code"), Function.identity()));
        Set<Container> containers = this._getContainersWithModifiedRules(catalog, orgUnit, type);
        for (Container container : containers) {
            List<RuleRecord> rules = "complementary".equals(type) ? this._getComplementaryRuleRecords(container) : this._getRuleRecords(container, type, thematics);
            for (RuleRecord rule : rules) {
                this._saxRule(container, rule);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rules");
    }

    private List<RuleRecord> _getRuleRecords(Container container, String type, Map<String, Content> thematics) {
        Predicate<ModelAwareRepeaterEntry> filter = "derogation".equals(type) ? e -> !e.hasValue("thematicCode") : e -> e.hasValue("thematicCode");
        return Optional.ofNullable(container).map(c -> (ModelAwareRepeater)c.getValue("rules")).map(ModelAwareRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).filter(filter).map(e -> this._entry2RuleRecord((ModelAwareRepeaterEntry)e, thematics)).toList();
    }

    private List<RuleRecord> _getComplementaryRuleRecords(Container container) {
        List thematicEntries = Optional.ofNullable(container).map(c -> (ModelAwareRepeater)c.getValue("thematics")).map(ModelAwareRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).toList();
        ArrayList<RuleRecord> rules = new ArrayList<RuleRecord>();
        for (ModelAwareRepeaterEntry thematicEntry : thematicEntries) {
            String thematicTitle = (String)thematicEntry.getValue("title");
            String thematicCode = (String)thematicEntry.getValue("code");
            ModelAwareRepeater rulesRepeater = thematicEntry.getRepeater("rules");
            if (rulesRepeater == null) continue;
            for (ModelAwareRepeaterEntry entry : rulesRepeater.getEntries()) {
                rules.add(new RuleRecord(entry, null, thematicCode, thematicTitle));
            }
        }
        return rules;
    }

    private RuleRecord _entry2RuleRecord(ModelAwareRepeaterEntry entry, Map<String, Content> thematics) {
        String ruleCode = (String)entry.getValue("code");
        String thematicCode = StringUtils.substringBefore((String)ruleCode, (String)"-");
        Content thematic = thematics.get(thematicCode);
        return new RuleRecord(entry, thematic, thematicCode, thematic.getTitle());
    }

    protected void _saxRule(Container container, RuleRecord rule) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"rule");
        ModelAwareRepeaterEntry entry = rule.ruleEntry();
        String ruleCode = (String)entry.getValue("code");
        this._saxThematic(rule);
        this._saxColumnValue("code", List.of(ruleCode));
        this._saxContainer(container);
        RichText derogation = (RichText)entry.getValue("text");
        List<String> derogationAsList = derogation != null ? List.of(this._richTextHelper.richTextToString(derogation)) : List.of();
        this._saxColumnValue("derogation", derogationAsList);
        RichText motivation = (RichText)entry.getValue("motivation");
        List<String> motivationAsList = motivation != null ? List.of(this._richTextHelper.richTextToString(motivation)) : List.of();
        this._saxColumnValue("motivation", motivationAsList);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rule");
    }

    protected void _saxThematic(RuleRecord thematic) throws SAXException {
        if (thematic != null) {
            Content content = thematic.thematicContent();
            List<String> regimes = Optional.ofNullable(content).map(c -> (ContentValue[])c.getValue("regime", false, (Object)new ContentValue[0])).map(Stream::of).orElseGet(() -> Stream.of(new ContentValue[0])).map(ContentValue::getContentIfExists).filter(Optional::isPresent).map(Optional::get).map(c -> c.getTitle()).toList();
            this._saxColumnValue("regimes", regimes);
            this._saxColumnValue("thematicCode", List.of(thematic.code()));
            this._saxColumnValue("thematicTitle", List.of(thematic.title()));
        } else {
            this._saxColumnValue("regimes", List.of());
            this._saxColumnValue("thematicCode", List.of());
            this._saxColumnValue("thematicTitle", List.of());
        }
    }

    protected void _saxContainer(Container container) throws SAXException {
        List<String> orgUnits = container.getOrgUnits().stream().map(id -> this._resolver.resolveById(id)).filter(OrgUnit.class::isInstance).map(OrgUnit.class::cast).map(DefaultContent::getTitle).toList();
        this._saxColumnValue("orgUnits", orgUnits);
        this._saxColumnValue("containerCode", List.of(container.getCode()));
        this._saxColumnValue("containerTitle", List.of(container.getTitle()));
    }

    protected Set<Container> _getContainersWithModifiedRules(String catalog, String orgUnit, String type) {
        HashSet<Container> containers = new HashSet<Container>();
        StringBuilder queryString = new StringBuilder("//element(*, ametys:container)[");
        queryString.append(this._getContainersPredicate(catalog, orgUnit));
        if ("complementary".equals(type)) {
            queryString.append("]/ametys:thematics/*");
        } else {
            queryString.append("]/ametys:rules/*[");
            queryString.append(this._getRulesPredicate(type));
            queryString.append("]");
        }
        try {
            Session session = this.getRepository().login();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            NodeIterator nodeIterator = query.execute().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                containers.add(this._getParentContainer(node));
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error("An error occurred getting containers with modified rules", (Throwable)e);
        }
        return containers;
    }

    private String _getContainersPredicate(String catalog, String orgUnit) {
        ArrayList<StringExpression> expressions = new ArrayList<StringExpression>();
        expressions.add(new StringExpression("catalog", Expression.Operator.EQ, catalog));
        if (StringUtils.isNotBlank((CharSequence)orgUnit)) {
            expressions.add(new StringExpression("orgUnit", Expression.Operator.EQ, orgUnit));
        }
        return new AndExpression(expressions).build();
    }

    private String _getRulesPredicate(String type) {
        if ("derogation".equals(type)) {
            return new OrExpression(new Expression[]{new NotExpression((Expression)new MetadataExpression("thematicCode")), new StringExpression("thematicCode", Expression.Operator.EQ, "")}).build();
        }
        return new StringExpression("thematicCode", Expression.Operator.NE, "").build();
    }

    private Container _getParentContainer(Node node) {
        try {
            for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.getPrimaryNodeType().isNodeType("ametys:container")) continue;
                return (Container)this._resolver.resolve(parent, false);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting the parent container", (Throwable)e);
        }
        throw new AmetysRepositoryException("We should find a parent container from node : " + node);
    }

    private void _saxColumnValue(String attribute, List<String> values) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", attribute);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"column", (Attributes)attrs);
        for (String value : values) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (String)value);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"column");
    }

    private record RuleRecord(ModelAwareRepeaterEntry ruleEntry, Content thematicContent, String code, String title) {
    }
}

