<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:stringutils="org.apache.commons.lang.StringUtils"
                xmlns:su="org.ametys.core.util.StringUtils"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="i18n exsl stringutils su">
    
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/utils.xsl"/>
    <xsl:import href="odf-view:odf-pilotage://stylesheets/pilotage/utils/xls.xsl"/>
    
    <xsl:variable name="naturesEnseignement">
        <xsl:for-each select="/report/items[@id = 'odf-enumeration.EnseignementNature']/category/item">
            <xsl:sort select="../@order" data-type="number"/>
            <xsl:sort select="../@code" data-type="text"/>
            <xsl:sort select="@order" data-type="number"/>
            <xsl:sort select="@code" data-type="text"/>
            <xsl:if test="@archived = 'false' or //nbHours[@nature = current()/@id]">
                <item id="{@id}" code="{@code}"><xsl:value-of select="."/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="nbVolumes" select="count(exsl:node-set($naturesEnseignement)/*)"/>
    
    <xsl:template name="table-head">
        <tr>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th></th>
            <th colspan="2"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_STEP_HOLDER"/></th>
            <th colspan="{$nbVolumes}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_VOLUME_MOYEN"/></th>
            <th colspan="{$nbVolumes}"><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_VOLUME_TOTAL"/></th>
        </tr>
        <tr>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_CODE_ANU"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_TYPE_DIPLOME"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_FORMATION"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_PARCOURS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_ANNEE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_CODE_ETP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_TYPE_UE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_SEMESTRE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_PERIODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_TYPE_PERIODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_CODE_AMETYS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_CODE_ELP"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_SHORT_LABEL"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_UE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_ECTS"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_SHARED"/></th>
            <!-- Step holder -->
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_STEP_HOLDER_CODE"/></th>
            <th><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_STEP_HOLDER_TITLE"/></th>
            <!-- Volumes -->
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <th><xsl:value-of select="@code"/></th>
            </xsl:for-each>
            <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                <th><xsl:value-of select="@code"/></th>
            </xsl:for-each>
        </tr>
    </xsl:template>
    
    <xsl:template name="table-body">
        <xsl:for-each select="lines/line">
            <tr>
                <td><xsl:value-of select="su:sanitizeXlsHtml(CodeAnu)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(degree)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(program)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(parcours)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(annee)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(etpCode)"/><xsl:if test="vrsEtpCode != ''">-<xsl:value-of select="vrsEtpCode"/></xsl:if></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(listType)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(semestre)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(periode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(typePeriode)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeAmetys)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(codeELP)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(shortLabel)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(title)"/></td>
                <td>
                    <xsl:call-template name="display-double">
                        <xsl:with-param name="value"><xsl:value-of select="ects"/></xsl:with-param>
                    </xsl:call-template>
                </td>
                <td><xsl:value-of select="isShared"/></td>
                
                <!-- Step holder -->
                <td><xsl:value-of select="su:sanitizeXlsHtml(stepHolder/code)"/></td>
                <td><xsl:value-of select="su:sanitizeXlsHtml(stepHolder/title)"/></td>
                
                <!-- Volumes -->
                <xsl:variable name="currentLine" select="."/>
                <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                    <td>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="$currentLine/nbHours[@type='average' and @nature=current()/@id]"/>
                        </xsl:call-template>
                    </td>
                </xsl:for-each>
                <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                    <td>
                        <xsl:call-template name="display-double">
                            <xsl:with-param name="value" select="$currentLine/nbHours[@type='total' and @nature=current()/@id]"/>
                        </xsl:call-template>
                    </td>
                </xsl:for-each>
            </tr>
        </xsl:for-each>
        <xsl:call-template name="legende"/>
    </xsl:template>
    
    <xsl:template name="legende">
        <tr>
            <td colspan="{14 + (2 * $nbVolumes)}"/>
        </tr>
        <tr>
            <td colspan="{14 + (2 * $nbVolumes)}">
                <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_LEGENDE"/></strong>
            </td>
        </tr>
        <tr>
            <td colspan="{14 + (2 * $nbVolumes)}"/>
        </tr>
        <xsl:call-template name="legende-enseignement-nature"/>
    </xsl:template>
    
    <xsl:template name="legende-enseignement-nature">
        <xsl:if test="$nbVolumes > 0">
            <tr>
                <td colspan="{14 + (2 * $nbVolumes)}">
                    <strong><i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_LEGENDE_ENSEIGNEMENT_NATURE"/></strong>
                    <ul>
                        <xsl:for-each select="exsl:node-set($naturesEnseignement)/*">
                            <li>
                                <strong><xsl:value-of select="@code"/></strong>
                                <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_VOLUME_HORAIRE_LEGENDE_SEPARATOR"/>
                                <xsl:value-of select="."/>
                            </li>
                        </xsl:for-each>
                    </ul>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
