/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.actions;

import java.util.ArrayList;
import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper.ODFWorkflowStep;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageStatusHelper.PilotageStatus;

/**
 * This action returns the pilotage status history of a content
 *
 */
public class ODFPilotageContentHistoryAction extends AbstractProgramItemHistoryAction
{
    /** The pilotage status helper */
    protected PilotageStatusHelper _pilotageStatusHelper;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _pilotageStatusHelper = (PilotageStatusHelper) serviceManager.lookup(PilotageStatusHelper.ROLE);
    }
    
    @Override
    protected Program getParentProgramItemForHistory(ProgramItem programItem)
    {
        return _pilotageStatusHelper.getParentProgramWithHigherPilotageStatus(programItem);
    }
    
    @Override
    protected List<ODFWorkflowStep> getWorkflowSteps(ProgramItem programItem)
    {
        List<ODFWorkflowStep> workflowSteps = new ArrayList<>();
        
        if (programItem instanceof Program program)
        {
            PilotageStatus pilotageStatus = _pilotageStatusHelper.getPilotageStatus(program);
            switch (pilotageStatus)
            {
                case MENTION_VALIDATED:
                    workflowSteps.add(_pilotageStatusHelper.getMentionValidationStep(program));
                    break;
                case ORGUNIT_VALIDATED:
                    workflowSteps.add(_pilotageStatusHelper.getOrgUnitValidationStep(program));
                    workflowSteps.add(_pilotageStatusHelper.getMentionValidationStep(program));
                    break;
                case CFVU_VALIDATED:
                    workflowSteps.add(_pilotageStatusHelper.getCFVUValidationStep(program));
                    workflowSteps.add(_pilotageStatusHelper.getOrgUnitValidationStep(program));
                    workflowSteps.add(_pilotageStatusHelper.getMentionValidationStep(program));
                    break;
                default:
                    break;
            }
        }
        
        return workflowSteps;
    }
}
