/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;

/**
 * Observer to add number of session and regime old values request of modified container
 */
public class UpdateContainerRulesStep1Observer extends AbstractRulesStepObserver
{
    @Override
    protected String getSupportedEventId()
    {
        return ObservationConstants.EVENT_CONTENT_MODIFYING;
    }
    
    @Override
    protected boolean supportsContent(Content content)
    {
        return _pilotageHelper.isContainerOfTypeYear(content);
    }
    
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        
        List<String> regimeId = Optional.ofNullable(content.<ContentValue>getValue(PilotageHelper.CONTAINER_MCC_REGIME))
                .map(ContentValue::getContentId)
                .map(List::of)
                .orElseGet(List::of);
        _addOldRegimeIds(content, regimeId);
        
        String nbSessions = content.getValue(PilotageHelper.CONTAINER_MCC_NUMBER_OF_SESSIONS);
        _addOldNbSessions(content, nbSessions);
    }
}
