/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.helper;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.cms.data.holder.group.ModifiableIndexableComposite;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowException;
import org.ametys.plugins.odfpilotage.rule.RulesManager;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MCCWorkflowHelper
extends AbstractWorkflowHelper
implements Initializable {
    public static final String ROLE = MCCWorkflowHelper.class.getName();
    public static final String RULES_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_Rules_Validated_Super_Rights";
    public static final String MCC_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_Validated_Super_Rights";
    public static final String MCC_ORGUNIT_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights";
    public static final String MCC_CFVU_VALIDATED_SUPER_RIGHT_ID = "ODF_Pilotage_MCC_CFVU_Validated_Super_Rights";
    public static final String MCC_VALIDATED_PDF_REPEATER = "mcc-validated-pdf";
    public static final Integer MCC_WORKFLOW_ACTION_ID = 222222;
    private static final String __MCC_WORKFLOW_COMPOSITE = "mcc_workflow";
    private static final String __STATUS_SUFFIX = "_status";
    private static final String __MCC_VALIDATION_PREFIX = "mcc_validation";
    private static final String __RULES_VALIDATION_PREFIX = "rules_validation";
    private static final String __MCC_ORGUNIT_VALIDATION_PREFIX = "mcc_orgunit_validation";
    private static final String __CFVU_MCC_VALIDATION_PREFIX = "cfvu_mcc_validation";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainers";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainersForRules";
    private static final String __PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID = MCCWorkflowHelper.class.getName() + "$parentContainersForMCC";
    protected ContentWorkflowHelper _contentWorkflowHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_CFVU_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_CFVU_STATUS_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_RULES_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_RULES_STATUS_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID, new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_STATUS_LABEL"), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_CACHE_CONTAINER_WITH_HIGHER_MCC_STATUS_DESCRIPTION"), true);
    }

    private Cache<String, String> _getContainerParentsCache() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID);
    }

    private Cache<String, String> _getContainerParentsCacheForRules() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID);
    }

    private Cache<String, String> _getContainerParentsCacheForMCC() {
        return this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID);
    }

    public void invalidateAllCaches() {
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_STATUS_CACHE_ID).invalidateAll();
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_RULES_STATUS_CACHE_ID).invalidateAll();
        this._cacheManager.get(__PARENT_CONTAINERS_WITH_HIGHER_MCC_STATUS_CACHE_ID).invalidateAll();
    }

    public Container getParentContainerWithHigherMCCStatus(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCache();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container parentContainer = this._computeParentContainerWithHigherMCCStatus(programItem);
        cache.put((Object)programItem.getId(), (Object)(parentContainer != null ? parentContainer.getId() : null));
        return parentContainer;
    }

    private Container _computeParentContainerWithHigherMCCStatus(ProgramItem programItem) {
        Set<Container> parentContainers = this._getParentYearContainers(programItem);
        return parentContainers.stream().sorted(new MCCStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatus(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCache();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container parentContainer = this._computeParentContainerWithHigherMCCStatus(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(parentContainer != null ? parentContainer.getId() : null));
        return parentContainer;
    }

    private Container _computeParentContainerWithHigherMCCStatus(CoursePart coursePart) {
        Set<Container> parentPrograms = this._getParentYearContainers(coursePart);
        return parentPrograms.stream().sorted(new MCCStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForRules(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCacheForRules();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForRules(programItem);
        cache.put((Object)programItem.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForRules(ProgramItem programItem) {
        Set<Container> yearContainers = this._getParentYearContainers(programItem);
        return yearContainers.stream().sorted(new ContainerMCCRulesStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForRules(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCacheForRules();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForRules(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForRules(CoursePart coursePart) {
        Set<Container> yearContainers = this._getParentYearContainers(coursePart);
        return yearContainers.stream().sorted(new ContainerMCCRulesStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForMCCFields(ProgramItem programItem) {
        Cache<String, String> cache = this._getContainerParentsCacheForMCC();
        if (cache.hasKey((Object)programItem.getId())) {
            String parentId = (String)cache.get((Object)programItem.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForMCCFields(programItem);
        cache.put((Object)programItem.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForMCCFields(ProgramItem programItem) {
        Set<Container> yearContainers = this._getParentYearContainers(programItem);
        return yearContainers.stream().sorted(new ContainerMCCFieldsStatusComparator().reversed()).findFirst().orElse(null);
    }

    public Container getParentContainerWithHigherMCCStatusForMCCFields(CoursePart coursePart) {
        Cache<String, String> cache = this._getContainerParentsCacheForMCC();
        if (cache.hasKey((Object)coursePart.getId())) {
            String parentId = (String)cache.get((Object)coursePart.getId());
            return parentId != null ? (Container)this._resolver.resolveById(parentId) : null;
        }
        Container container = this._computeParentContainerWithHigherMCCStatusForMCCFields(coursePart);
        cache.put((Object)coursePart.getId(), (Object)(container != null ? container.getId() : null));
        return container;
    }

    private Container _computeParentContainerWithHigherMCCStatusForMCCFields(CoursePart coursePart) {
        Set<Container> yearContainers = this._getParentYearContainers(coursePart);
        return yearContainers.stream().sorted(new ContainerMCCFieldsStatusComparator().reversed()).findFirst().orElse(null);
    }

    public boolean validateOrgunitMCC(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (RulesManager.isRulesEnabled() && !this.isRulesValidated(container)) {
            throw new MCCWorkflowException("MCC can not be validated to orgunit level as rules are not validated for container " + container, MCCWorkflowException.ExceptionType.RULES_VALIDATION_REQUIRED);
        }
        if (!this.isMCCValidated(container)) {
            throw new MCCWorkflowException("MCC can not be validated to orgunit level as MCC are not validated for container " + container, MCCWorkflowException.ExceptionType.MCC_VALIDATION_REQUIRED);
        }
        if (this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("MCC can not be validated to orgunit level as there are already validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATED);
        }
        if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue())) {
            throw new MCCWorkflowException("Container data or structure are not valid. Orgunit MCC can't be validated for container : " + container, MCCWorkflowException.ExceptionType.WORKFLOW_INVALID);
        }
        return this._setMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean invalidateOrgunitMCC(Container container) throws MCCWorkflowException {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (this.isMCCCFVUValidated(container)) {
            throw new MCCWorkflowException("MCC can not be invalidate to orgunit level as MCC are already CFVU validated for container " + container, MCCWorkflowException.ExceptionType.MCC_CFVU_VALIDATED);
        }
        return this._removeMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public boolean isMCCOrgunitValidated(Container container) {
        return this._getMCCStatus(container, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public boolean validateMCC(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue())) {
            throw new MCCWorkflowException("Container data or structure are not valid. MCC can't be validated for container : " + container, MCCWorkflowException.ExceptionType.WORKFLOW_INVALID);
        }
        return this._setMCCStatus(container, __MCC_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean invalidateMCC(Container container) throws MCCWorkflowException {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("MCC can not be invalidate as MCC are already validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATED);
        }
        return this._removeMCCStatus(container, __MCC_VALIDATION_PREFIX);
    }

    public boolean isMCCValidated(Container container) {
        return this._getMCCStatus(container, __MCC_VALIDATION_PREFIX);
    }

    public boolean validateRules(Container container, LocalDate date, UserIdentity user, String comment) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("Rules can not be invalidate as rules are already validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATED);
        }
        if (!this._isRuleActionAvailable(container)) {
            throw new MCCWorkflowException("Container data or structure are not valid. Rules can't be validated for container : " + container, MCCWorkflowException.ExceptionType.WORKFLOW_INVALID);
        }
        return this._setMCCStatus(container, __RULES_VALIDATION_PREFIX, date, user, comment);
    }

    public boolean invalidateRules(Container container) throws MCCWorkflowException {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("Rules can not be invalidate as rules are already validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATED);
        }
        return this._removeMCCStatus(container, __RULES_VALIDATION_PREFIX);
    }

    public boolean isRulesValidated(Container container) {
        return this._getMCCStatus(container, __RULES_VALIDATION_PREFIX);
    }

    public boolean isMCCCFVUValidated(Container container) {
        return this._getMCCStatus(container, __CFVU_MCC_VALIDATION_PREFIX);
    }

    public boolean canValidateRules(Container container) {
        return this._isRuleActionAvailable(container);
    }

    private boolean _isRuleActionAvailable(Container container) {
        HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
        inputs.put("checkTree", false);
        return this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue(), inputs);
    }

    public boolean canValidateMCC(Container container) {
        return this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue());
    }

    public boolean canValidateOrgUnitMCC(Container container) {
        return this.isMCCValidated(container) && (!RulesManager.isRulesEnabled() || this.isRulesValidated(container)) && this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue());
    }

    public boolean canValidateCFVUMCC(Container container) {
        return this.isMCCOrgunitValidated(container) && this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue());
    }

    public LocalDate getMinDateForMCCOrgUnitValidation(Container container) {
        LocalDate rulesMentionDate;
        if (!this.isMCCValidated(container)) {
            throw new MCCWorkflowException("MCC can not be validated as MCC are not validated to mention level for container " + container, MCCWorkflowException.ExceptionType.MCC_VALIDATION_REQUIRED);
        }
        if (RulesManager.isRulesEnabled() && !this.isRulesValidated(container)) {
            throw new MCCWorkflowException("MCC can not be validated as rules are not validated to mention level for container " + container, MCCWorkflowException.ExceptionType.RULES_VALIDATION_REQUIRED);
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        LocalDate mccMentionDate = (LocalDate)composite.getValue("mcc_validation_date");
        LocalDate localDate = rulesMentionDate = RulesManager.isRulesEnabled() ? (LocalDate)composite.getValue("rules_validation_date") : null;
        return rulesMentionDate == null ? mccMentionDate : (mccMentionDate.compareTo(rulesMentionDate) > 0 ? mccMentionDate : rulesMentionDate);
    }

    public LocalDate getMinDateForMCCCFVUValidation(Container container) {
        if (!this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("MCC can not be CFVU validated as MCC are not validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATION_REQUIRED);
        }
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("mcc_orgunit_validation_date");
    }

    public LocalDate getMCCCFVUValidationDate(Container container) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
        return (LocalDate)composite.getValue("cfvu_mcc_validation_date");
    }

    public boolean validateMCCForCVFU(Container container, LocalDate validationDate, UserIdentity user, String comment) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        if (!this.isMCCOrgunitValidated(container)) {
            throw new MCCWorkflowException("MCC can not be CFVU validated as MCC are not validated to orgunit level for container " + container, MCCWorkflowException.ExceptionType.MCC_ORGUNIT_VALIDATION_REQUIRED);
        }
        if (this.isMCCCFVUValidated(container)) {
            throw new MCCWorkflowException("MCC can not be CFVU validated as MCC are already validated to CFVU for container " + container, MCCWorkflowException.ExceptionType.MCC_CFVU_VALIDATED);
        }
        if (!this._contentWorkflowHelper.isAvailableAction((WorkflowAwareContent)container, MCC_WORKFLOW_ACTION_ID.intValue())) {
            throw new MCCWorkflowException("Container data or structure are not valid. MCC for CFVU can't be validated for container : " + container, MCCWorkflowException.ExceptionType.WORKFLOW_INVALID);
        }
        return this._setMCCStatus(container, __CFVU_MCC_VALIDATION_PREFIX, validationDate, user, comment);
    }

    public boolean invalidateMCCForCVFU(Container container) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new MCCWorkflowException("Can not update MCC status on a container that is not of type year: " + container, MCCWorkflowException.ExceptionType.NOT_TYPE_YEAR);
        }
        return this._removeMCCStatus(container, __CFVU_MCC_VALIDATION_PREFIX);
    }

    public boolean removeMCCWorkflow(Container container) {
        container.removeValue(__MCC_WORKFLOW_COMPOSITE);
        return this.saveContent((ModifiableDefaultContent)container);
    }

    public boolean removeMCCValidatedPDF(Container container) {
        container.removeValue(MCC_VALIDATED_PDF_REPEATER);
        return this.saveContent((ModifiableDefaultContent)container);
    }

    private boolean _setMCCStatus(Container container, String prefixAttributeName, LocalDate validationDate, UserIdentity user, String comment) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE, true);
        composite.setValue(prefixAttributeName + __STATUS_SUFFIX, (Object)true);
        this.setWorkflowStep((ModifiableDefaultContent)container, (ModifiableModelAwareDataHolder)composite, prefixAttributeName, validationDate, user, comment);
        return this.saveContentAndNotify((ModifiableDefaultContent)container);
    }

    private boolean _removeMCCStatus(Container container, String prefixAttributeName) {
        ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE, true);
        composite.setValue(prefixAttributeName + __STATUS_SUFFIX, (Object)false);
        this.removeWorkflowStep((ModifiableDefaultContent)container, (ModifiableModelAwareDataHolder)composite, prefixAttributeName);
        return this.saveContentAndNotify((ModifiableDefaultContent)container);
    }

    private boolean _getMCCStatus(Container container, String attributeName) {
        return (Boolean)container.getValue("mcc_workflow/" + attributeName + __STATUS_SUFFIX, false, (Object)false);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getRulesMentionValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.RULES_VALIDATED, __RULES_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCMentionValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_VALIDATED, __MCC_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getMCCOrgunitValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.MCC_ORGUNIT_VALIDATED, __MCC_ORGUNIT_VALIDATION_PREFIX);
    }

    public AbstractWorkflowHelper.ODFWorkflowStep getCFVUMCCValidationStep(Container container) {
        return this._getMCCWorkflowStep(container, MCCWorkflowStep.CFVU_MCC_VALIDATED, __CFVU_MCC_VALIDATION_PREFIX);
    }

    private AbstractWorkflowHelper.ODFWorkflowStep _getMCCWorkflowStep(Container container, MCCWorkflowStep step, String attributeNamePrefix) {
        boolean status;
        if (container.hasValue(__MCC_WORKFLOW_COMPOSITE) && (status = this._getMCCStatus(container, attributeNamePrefix))) {
            ModifiableIndexableComposite composite = container.getComposite(__MCC_WORKFLOW_COMPOSITE);
            return this.getWorkflowStep((ModelAwareDataHolder)composite, attributeNamePrefix, step.name());
        }
        return null;
    }

    public ModelAwareRepeaterEntry getLastMCCValidatedEntry(Container container) {
        return Optional.ofNullable(container.getRepeater(MCC_VALIDATED_PDF_REPEATER)).map(ModelAwareRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModelAwareRepeaterEntry[0])).filter(e -> e.hasValue("pdf")).max((entry1, entry2) -> ((LocalDate)entry1.getValue("date")).compareTo((ChronoLocalDate)entry2.getValue("date"))).orElse(null);
    }

    private final class MCCStatusComparator
    implements Comparator<Container> {
        private MCCStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean rulesMentionValidated1 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c1);
            boolean mccMentionValidated1 = MCCWorkflowHelper.this.isMCCValidated(c1);
            boolean rulesValidated2 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c2);
            boolean mccMentionValidated2 = MCCWorkflowHelper.this.isMCCValidated(c2);
            if (rulesMentionValidated1 && mccMentionValidated1) {
                if (!mccMentionValidated2 || !rulesValidated2) {
                    return 1;
                }
                return 0;
            }
            if (rulesMentionValidated1 || mccMentionValidated1) {
                if (rulesValidated2 && !mccMentionValidated2 || !rulesValidated2 && mccMentionValidated2) {
                    return 0;
                }
                if (rulesValidated2 && mccMentionValidated2) {
                    return -1;
                }
                return 1;
            }
            return !rulesValidated2 && !mccMentionValidated2 ? 0 : -1;
        }
    }

    private final class ContainerMCCRulesStatusComparator
    implements Comparator<Container> {
        private ContainerMCCRulesStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean rulesValidated2;
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean rulesValidated1 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c1);
            boolean bl = rulesValidated2 = RulesManager.isRulesEnabled() && MCCWorkflowHelper.this.isRulesValidated(c2);
            if (rulesValidated1) {
                return rulesValidated2 ? 0 : 1;
            }
            return rulesValidated2 ? -1 : 0;
        }
    }

    private final class ContainerMCCFieldsStatusComparator
    implements Comparator<Container> {
        private ContainerMCCFieldsStatusComparator() {
        }

        @Override
        public int compare(Container c1, Container c2) {
            boolean mccValidated1 = MCCWorkflowHelper.this.isMCCCFVUValidated(c1);
            boolean mccValidated2 = MCCWorkflowHelper.this.isMCCCFVUValidated(c2);
            if (mccValidated1) {
                return mccValidated2 ? 0 : 1;
            }
            if (mccValidated2) {
                return -1;
            }
            boolean mccOrgunitValidated1 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c1);
            boolean mccOrgunitValidated2 = MCCWorkflowHelper.this.isMCCOrgunitValidated(c2);
            if (mccOrgunitValidated1) {
                return mccOrgunitValidated2 ? 0 : 1;
            }
            if (mccOrgunitValidated2) {
                return -1;
            }
            boolean mccMentionValidated1 = MCCWorkflowHelper.this.isMCCValidated(c1);
            boolean mccMentionValidated2 = MCCWorkflowHelper.this.isMCCValidated(c2);
            if (mccMentionValidated1) {
                return mccMentionValidated2 ? 0 : 1;
            }
            return mccMentionValidated2 ? -1 : 0;
        }
    }

    public static enum MCCWorkflowStep {
        RULES_VALIDATED,
        MCC_VALIDATED,
        MCC_ORGUNIT_VALIDATED,
        CFVU_MCC_VALIDATED;

    }
}

