/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.observations;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.odfpilotage.rule.observations.AbstractRulesStepObserver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class UpdateThematicRulesStep1Observer
extends AbstractRulesStepObserver {
    protected ContentTypesHelper _contentTypesHelper;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    @Override
    protected String getSupportedEventId() {
        return "content.modifying";
    }

    @Override
    protected boolean supportsContent(Content content) {
        return this._contentTypesHelper.isInstanceOf(content, "odf-enumeration.Thematic");
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Content content = (Content)event.getArguments().get("content");
        List<String> degreeIds = Stream.of((ContentValue[])content.getValue("degree", false, (Object)new ContentValue[0])).map(ContentValue::getContentId).toList();
        this._addOldDegreeIds(content, degreeIds);
        List<String> regimeIds = Stream.of((ContentValue[])content.getValue("regime", false, (Object)new ContentValue[0])).map(ContentValue::getContentId).toList();
        this._addOldRegimeIds(content, regimeIds);
        String nbSessions = (String)content.getValue("nbSessions");
        this._addOldNbSessions(content, nbSessions);
        List<String> modifiedRuleCodes = Optional.ofNullable(content).map(c -> (ModifiableIndexableRepeater)c.getValue("rules")).map(ModifiableIndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModifiableIndexableRepeaterEntry[0])).filter(e -> "MODIFIED".equals(e.getValue("status"))).map(e -> (String)e.getValue("code")).toList();
        this._addOldModifiedRuleCodes(content, modifiedRuleCodes);
    }
}

