/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.plugins.odfpilotage.helper.PilotageClientSideElementHelper;

/**
 * Override button for odf content to take into account the attribute restrictions
 */
public class ODFPilotageSimpleMenuClientSideElement extends SimpleMenu
{
    /** The pilotage status helper */
    protected PilotageClientSideElementHelper _pilotageClientSideHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _pilotageClientSideHelper = (PilotageClientSideElementHelper) smanager.lookup(PilotageClientSideElementHelper.ROLE);
    }
    
    /**
     * Get the status of content from the point of view of restrictions on attributes
     * @param contentId the id of content
     * @param modelPath the path of attribute
     * @return informations on contents' state
     */
    @Callable
    public Map<String, Object> getRestrictionStatus(String contentId, String modelPath)
    {
        Map<String, Object> result = new HashMap<>();
        _pilotageClientSideHelper.getRestrictionStatus(List.of(contentId), modelPath, result);
        return result;
    }
}
