/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.clientsideelement;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.TraversableProgramPart;
import org.ametys.plugins.odfpilotage.clientsideelement.MCCWorkflowClientSideElement;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;

public class ProgramMCCWorkflowClientSideElement
extends MCCWorkflowClientSideElement {
    @Callable
    public Map<String, Object> getStatus(String programId, String mccStatus) {
        Program program = (Program)this._resolver.resolveById(programId);
        Set<Container> childYears = this._pilotageHelper.getYears((TraversableProgramPart)program);
        if (childYears.isEmpty()) {
            return Map.of("no-years", true);
        }
        switch (MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus)) {
            case MCC_ORGUNIT_VALIDATED: {
                if (childYears.stream().allMatch(this._mccWorkflowHelper::isMCCOrgunitValidated)) {
                    return Map.of("all-active", true);
                }
                if (childYears.stream().anyMatch(this._mccWorkflowHelper::canValidateOrgUnitMCC)) break;
                return Map.of("no-available", true);
            }
            case CFVU_MCC_VALIDATED: {
                if (childYears.stream().allMatch(this._mccWorkflowHelper::isMCCCFVUValidated)) {
                    return Map.of("all-active", true);
                }
                if (childYears.stream().anyMatch(this._mccWorkflowHelper::canValidateCFVUMCC)) break;
                return Map.of("no-available", true);
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for MCC status : " + mccStatus);
            }
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("active-contents", new ArrayList());
        results.put("allright-contents", new ArrayList());
        List activeContents = (List)results.get("active-contents");
        for (Container year : childYears) {
            this._getContainerStatus(year, mccStatus, activeContents);
        }
        Map contentParams = this.getContentDefaultParameters((Content)program);
        contentParams.put("description", this._getAllRightDescription((Content)program));
        List allrightContents = (List)results.get("allright-contents");
        allrightContents.add(contentParams);
        return results;
    }

    private void _getContainerStatus(Container container, String mccStatus, List<Map<String, Object>> activeContents) {
        Map defaultContentParams = this.getContentDefaultParameters((Content)container);
        switch (MCCWorkflowHelper.MCCWorkflowStep.valueOf(mccStatus)) {
            case MCC_ORGUNIT_VALIDATED: {
                if (!this._mccWorkflowHelper.isMCCOrgunitValidated(container)) break;
                HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                activeContentParams.put("description", this._getActiveDescription((Content)container));
                activeContents.add(activeContentParams);
                break;
            }
            case CFVU_MCC_VALIDATED: {
                if (!this._mccWorkflowHelper.isMCCCFVUValidated(container)) break;
                HashMap<String, I18nizableText> activeContentParams = new HashMap<String, I18nizableText>(defaultContentParams);
                activeContentParams.put("description", this._getActiveDescription((Content)container));
                activeContents.add(activeContentParams);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for MCC status : " + mccStatus);
            }
        }
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCOrgUnitValidation(String programItemId) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._pilotageHelper.getYears(programItem).stream().filter(this._mccWorkflowHelper::canValidateOrgUnitMCC).map(SimpleAmetysObject::getId).toList();
        return super.getMinDateForMCCOrgUnitValidation(childYearIds);
    }

    @Callable(rights={""})
    public LocalDate getMinDateForMCCCFVUValidation(String programItemId) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._pilotageHelper.getYears(programItem).stream().filter(this._mccWorkflowHelper::canValidateCFVUMCC).map(SimpleAmetysObject::getId).toList();
        return super.getMinDateForMCCCFVUValidation(childYearIds);
    }

    @Callable(rights={""})
    public Map<String, Object> validateOrgunitMCC(String programItemId, String validationDate, String comment) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._pilotageHelper.getYears(programItem).stream().filter(c -> !this._mccWorkflowHelper.isMCCOrgunitValidated((Container)c)).map(SimpleAmetysObject::getId).toList();
        return this.validateOrgunitMCC(childYearIds, validationDate, comment);
    }

    @Callable(rights={""})
    public Map<String, Object> validateMCCForCVFU(String programItemId, String validationDate, String comment, Map<String, Object> contextualParameters) {
        TraversableProgramPart programItem = (TraversableProgramPart)this._resolver.resolveById(programItemId);
        List<String> childYearIds = this._pilotageHelper.getYears(programItem).stream().filter(c -> !this._mccWorkflowHelper.isMCCCFVUValidated((Container)c)).map(SimpleAmetysObject::getId).toList();
        return this.validateMCCForCVFU(childYearIds, validationDate, comment, contextualParameters);
    }
}

