/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.property;

import java.util.ArrayList;
import java.util.Map;
import org.ametys.cms.model.properties.AbstractProperty;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.StaticEnumerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContainerMCCWorkflowStatusProperty
extends AbstractProperty<String, Container>
implements Serviceable {
    private MCCWorkflowHelper _mccWorkflowHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)smanager.lookup(MCCWorkflowHelper.ROLE));
    }

    public Object getValue(Container container) {
        ArrayList<String> status = new ArrayList<String>();
        if (this._mccWorkflowHelper.isMCCCFVUValidated(container)) {
            status.add(MCCWorkflowHelper.MCCWorkflowStep.CFVU_MCC_VALIDATED.name());
        } else if (this._mccWorkflowHelper.isMCCOrgunitValidated(container)) {
            status.add(MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_VALIDATED.name());
        } else {
            if (this._mccWorkflowHelper.isRulesValidated(container)) {
                status.add(MCCWorkflowHelper.MCCWorkflowStep.RULES_VALIDATED.name());
            }
            if (this._mccWorkflowHelper.isMCCValidated(container)) {
                status.add(MCCWorkflowHelper.MCCWorkflowStep.MCC_VALIDATED.name());
            }
        }
        return status.toArray(String[]::new);
    }

    public Enumerator<String> getEnumerator() {
        StaticEnumerator enumerator = new StaticEnumerator();
        enumerator.addAll(Map.of(MCCWorkflowHelper.MCCWorkflowStep.CFVU_MCC_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_CFVU_VALIDATED_LABEL"), MCCWorkflowHelper.MCCWorkflowStep.MCC_ORGUNIT_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MCC_ORGUNIT_VALIDATED_LABEL"), MCCWorkflowHelper.MCCWorkflowStep.RULES_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_RULES_VALIDATED_LABEL"), MCCWorkflowHelper.MCCWorkflowStep.MCC_VALIDATED.name(), new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_MCC_WORKFLOW_MCC_VALIDATED_LABEL")));
        return enumerator;
    }

    public boolean isMultiple() {
        return true;
    }

    protected String _getTypeId() {
        return "string";
    }
}

