/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.tool;

import java.io.File;
import java.io.FileFilter;
import java.time.ZonedDateTime;
import org.ametys.core.util.DateUtils;

public class PilotageFileFilter
implements FileFilter {
    private ZonedDateTime _lastModifiedAfter;
    private ZonedDateTime _lastModifiedBefore;
    private String _fileName;

    public PilotageFileFilter(String fileName, ZonedDateTime lastModifiedAfter, ZonedDateTime lastModifiedBefore) {
        this._fileName = fileName;
        this._lastModifiedAfter = lastModifiedAfter;
        this._lastModifiedBefore = lastModifiedBefore;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return false;
        }
        String fileName = pathname.getName().toLowerCase();
        if (!fileName.matches(".*\\.zip")) {
            return false;
        }
        if (this._fileName != null && !fileName.contains(this._fileName.toLowerCase())) {
            return false;
        }
        ZonedDateTime lastModified = DateUtils.asZonedDateTime((long)pathname.lastModified());
        if (this._lastModifiedAfter != null && lastModified.isBefore(this._lastModifiedAfter)) {
            return false;
        }
        return this._lastModifiedBefore == null || !lastModified.isAfter(this._lastModifiedBefore);
    }
}

