/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Combobox for rule status
 */
Ext.define('Ametys.plugins.odfpilotage.widget.SelectThematicStatus', {
    extend: 'Ametys.form.widget.ComboBox',
   
    constructor: function (config)
    {
        config = Ext.apply(config, {
            listeners: {
                scope: this,
                'change': function(cb, newValue, oldValue)
                {
                    //It's ready if no form (grid edition)
                    var isFormReady = !this.form || this.form.isFormReady();
                    if (isFormReady)
                    {
                        if (this._oldValue === undefined) {this._oldValue = oldValue || null};
                        
                        if (newValue != this._oldValue && (newValue == "SUSPENDED" || newValue == "MODIFIED"))
                        {
                            this.markWarning("{{i18n plugin.odf-pilotage:PLUGINS_ODF_PILOTAGE_TS_RULE_STATUS_WIDGET_WARNING_MSG}}");
                        }
                        else
                        {
                            this.clearWarning();
                        }
                    }
                }
            }
        });
        
        this.callParent(arguments);
    }, 
});
