<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">
    
    <xsl:import href="view://stylesheets/io/docbook2fo.xsl" />
    
    <xsl:param name="orientation" select="'portrait'"/>
    
    <xsl:variable name="watermark-size">25</xsl:variable>
    
    <xsl:template match="/*">
        <xsl:call-template name="root"/>
    </xsl:template>
    
    <xsl:template name="root">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="landscape" page-width="297mm" page-height="210mm" margin-left="1cm" margin-right="1cm" margin-top="1cm" margin-bottom="1cm">
                    <xsl:call-template name="page-regions">
                        <xsl:with-param name="currentOrientation" select="'landscape'"/>
                    </xsl:call-template>
                </fo:simple-page-master>
                <fo:simple-page-master master-name="portrait" page-width="210mm" page-height="297mm" margin-left="1cm" margin-right="1cm" margin-top="1cm" margin-bottom="1cm">
                    <xsl:call-template name="page-regions">
                        <xsl:with-param name="currentOrientation" select="'portrait'"/>
                    </xsl:call-template>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <fo:declarations>
                <x:xmpmeta xmlns:x="adobe:ns:meta/">
                    <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
                        <rdf:Description xmlns:dc="http://purl.org/dc/elements/1.1/">
                            <dc:title><xsl:call-template name="property-title"/></dc:title>
                            <dc:creator><i18n:text i18n:catalogue="application" i18n:key="APPLICATION_PRODUCT_LABEL"/></dc:creator>
                        </rdf:Description>
                    </rdf:RDF>
                </x:xmpmeta>
            </fo:declarations>
            
            <!--  The bookmark tree -->
            <xsl:call-template name="menu-items"/>
            
            <!-- Contents -->
            <xsl:call-template name="sequences"/>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="sequences">
        <xsl:call-template name="main-sequence"/>
    </xsl:template>
    
    <xsl:template name="main-sequence">
        <fo:page-sequence master-reference="{$orientation}" force-page-count="no-force" font-size="10pt" line-height="1.5">
            <xsl:call-template name="sequence-id"/>
            <xsl:call-template name="flows"/>
        </fo:page-sequence>
    </xsl:template>
    
    <xsl:template name="sequence-id">
        <xsl:attribute name="id">last-sequence</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="page-regions">
        <xsl:param name="currentOrientation"/>
        
        <fo:region-body margin-top="0" margin-bottom="7mm" />
        <fo:region-before extent="0cm" region-name="watermark-{$currentOrientation}"/>
        <fo:region-after extent="5mm" region-name="footer" />
    </xsl:template>
    
    <xsl:template name="menu-items"/>
    
    <xsl:template name="flows">
        <xsl:call-template name="xsl-region-before"/>
        <xsl:call-template name="xsl-region-after"/>
        <xsl:call-template name="main-flow"/>
    </xsl:template>
    
    <!-- // Header -->
    <xsl:template name="xsl-region-before"/>
    
    <xsl:template name="watermark">
        <fo:static-content flow-name="watermark-{$orientation}">
            <fo:block>
                <xsl:choose>
                    <xsl:when test="$orientation = 'portrait'">
                        <fo:instream-foreign-object content-width="210mm" content-height="297mm" dominant-baseline="central">
                            <svg width="210" height="298" xmlns="http://www.w3.org/2000/svg" version="1.1">
                                <text x="105" y="149" transform="rotate(-55 105 149)" font-size="{$watermark-size}" fill="lightgrey" dominant-baseline="central" text-anchor="middle">
                                    <xsl:call-template name="watermark-label"/>
                                </text>
                            </svg>
                        </fo:instream-foreign-object>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:instream-foreign-object content-width="297mm" content-height="210mm" dominant-baseline="central">
                            <svg width="298" height="210" xmlns="http://www.w3.org/2000/svg" version="1.1">
                                <text x="149" y="105" transform="rotate(-35 149 105)" font-size="{$watermark-size}" fill="lightgrey" dominant-baseline="central" text-anchor="middle">
                                    <xsl:call-template name="watermark-label"/>
                                </text>
                            </svg>
                        </fo:instream-foreign-object>
                    </xsl:otherwise>
                </xsl:choose>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    
    <xsl:template name="watermark-label">
        <i18n:text i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_WATERMARK_WORK" i18n:catalog="plugin.odf-pilotage"/>
    </xsl:template>
    <!-- // END Header -->
    
    <!-- // Footer -->
    <xsl:template name="xsl-region-after">
        <fo:static-content flow-name="footer">
            <fo:block font-size="80%">
                <fo:table table-layout="fixed">
                    <fo:table-column column-width="5cm"/>
                    <fo:table-column/>
                    <fo:table-column column-width="5cm"/>
                    <fo:table-body>
                        <fo:table-row display-align="center">
                            <fo:table-cell text-align="left" margin="0">
                                <fo:block><xsl:call-template name="date-footer" /></fo:block>
                            </fo:table-cell>
                            <fo:table-cell text-align="center">
                                <fo:block><xsl:call-template name="footer"/></fo:block>
                            </fo:table-cell>
                            <fo:table-cell text-align="right">
                                <fo:block>
                                    <fo:page-number />/<fo:page-number-citation-last ref-id="last-sequence"/>
                                </fo:block>
                            </fo:table-cell>
                        </fo:table-row>
                    </fo:table-body>
                </fo:table>
            </fo:block>
        </fo:static-content> 
    </xsl:template>
    
    <xsl:template name="date-footer">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.odf-pilotage" i18n:key="PLUGINS_ODF_PILOTAGE_EXPORT_DATE"/>
            <i18n:param><i18n:date-time pattern="dd/MM/yyyy HH:mm" /></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template name="footer">
        <xsl:call-template name="property-title"/>
    </xsl:template>
    <!-- // END Footer -->
    
    <xsl:template name="main-flow">
        <fo:flow flow-name="xsl-region-body">
            <xsl:call-template name="body"/>
        </fo:flow>
    </xsl:template>
    
    <!-- Newline to block tag. -->
    <xsl:template name="text.nl2block">
        <xsl:param name="input"/>
        <xsl:param name="s1"><xsl:text>
</xsl:text></xsl:param>
        
        <xsl:choose>
            <xsl:when test="contains($input, $s1)">
                <xsl:variable name="rest">
                    <xsl:call-template name="text.nl2block">
                        <xsl:with-param name="input" select="substring-after($input, $s1)"/>
                        <xsl:with-param name="s1" select="$s1"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="substring-before($input, $s1)"/>
                <fo:block />
                <xsl:copy-of select="$rest"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$input"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
