/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfpilotage.validator;

/**
 * Global validator for OrgUnit content.
 * Check that every instance of the repeater potentielsEnseignement have a different discipline.
 */
public class PotentielEnseignantValidator extends AbstractRepeaterWithUniqueContentValidator
{
    @Override
    protected String getRepeaterName()
    {
        return "potentielsEnseignant";
    }

    @Override
    protected String getContentDataName()
    {
        return "discipline";
    }

    @Override
    protected String getErrorKey()
    {
        return "PLUGINS_ODF_PILOTAGE_POTENTIEL_ENSEIGNANT_VALIDATOR_ERROR";
    }
}
