/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.actions;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.odfpilotage.helper.AbstractWorkflowHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public abstract class AbstractProgramItemHistoryAction
extends ServiceableAction {
    protected UserHelper _userHelper;
    protected AmetysObjectResolver _resolver;
    protected ContentHelper _contentHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String id = request.getParameter("contentId");
        ProgramItem programItem = (ProgramItem)this._resolver.resolveById(id);
        ProgramItem parentProgramItem = this.getParentProgramItemForHistory(programItem);
        if (parentProgramItem != null) {
            List<AbstractWorkflowHelper.ODFWorkflowStep> workflowSteps = this.getWorkflowSteps(parentProgramItem);
            List workflowHistory = workflowSteps.stream().map(this::workflowStepToJson).collect(Collectors.toList());
            result.put("workflow", workflowHistory);
            result.put("title", this._contentHelper.getTitle((Content)parentProgramItem));
            result.put("isParentProgram", !parentProgramItem.getId().equals(programItem.getId()));
        } else {
            result.put("workflow", List.of());
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected abstract ProgramItem getParentProgramItemForHistory(ProgramItem var1);

    protected abstract List<AbstractWorkflowHelper.ODFWorkflowStep> getWorkflowSteps(ProgramItem var1);

    protected Map<String, Object> workflowStepToJson(AbstractWorkflowHelper.ODFWorkflowStep step) {
        HashMap<String, Object> step2json = new HashMap<String, Object>();
        step2json.put("id", step.id());
        UserIdentity author = step.author();
        step2json.put("author", this._userHelper.user2json(author));
        step2json.put("comment", step.comment());
        step2json.put("date", DateUtils.localDateToString((LocalDate)step.date()));
        step2json.put("title", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_WORKFLOW_" + step.id().toUpperCase() + "_ACTION_LABEL"));
        step2json.put("actionLabel", new I18nizableText("plugin.odf-pilotage", "PLUGINS_ODF_PILOTAGE_WORKFLOW_" + step.id().toUpperCase() + "_ACTION_DESCRIPTION"));
        return step2json;
    }
}

