/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.cost.entity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OverriddenData {
    private Map<String, Double> _volumeOfHours = new HashMap<String, Double>();
    private Map<String, Long> _groups = new HashMap<String, Long>();
    private Map<String, Long> _effectives = new HashMap<String, Long>();

    public OverriddenData(Map<String, Map<String, String>> overriddenData) {
        for (Map.Entry<String, Map<String, String>> json : overriddenData.entrySet()) {
            String contentId = json.getKey();
            Map<String, String> overriddenValues = json.getValue();
            Iterator<String> iterator = overriddenValues.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "effectivesGlobal": {
                        this._effectives.put(contentId, Long.parseLong(overriddenValues.get(key)));
                        break;
                    }
                    case "groups": {
                        this._groups.put(contentId, Long.parseLong(overriddenValues.get(key)));
                        break;
                    }
                    case "nbHours": {
                        this._volumeOfHours.put(contentId, Double.parseDouble(overriddenValues.get(key)));
                        break;
                    }
                }
            }
        }
    }

    public OverriddenData() {
        this(Map.of());
    }

    public Double getVolumeOfHours(String programItemId) {
        return this._volumeOfHours.get(programItemId);
    }

    public Long getEffective(String programItemId) {
        return this._effectives.get(programItemId);
    }

    public Long getNumberOfGroups(String programItemId) {
        return this._groups.get(programItemId);
    }
}

