/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeaterEntry;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.content.CopyContentComponent;
import org.ametys.odf.program.Container;
import org.ametys.plugins.odfpilotage.helper.MCCWorkflowHelper;
import org.ametys.plugins.odfpilotage.helper.PilotageHelper;
import org.ametys.plugins.odfpilotage.rule.ThematicsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.model.RepositoryDataContext;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RulesManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = RulesManager.class.getName();
    public static final String THEMATIC_CONTENT_TYPE = "odf-enumeration.Thematic";
    public static final String CONTAINER_THEMATICS = "thematics";
    public static final String THEMATIC_DEGREE = "degree";
    public static final String THEMATIC_REGIME = "regime";
    public static final String THEMATIC_NB_SESSIONS = "nbSessions";
    public static final String THEMATIC_RULES = "rules";
    public static final String CONTAINER_RULES = "rules";
    public static final String THEMATIC_CODE = "code";
    public static final String RULE_THEMATIC_CODE = "thematicCode";
    public static final String RULE_CODE = "code";
    public static final String RULE_HELP_TEXT = "helpTextDerogation";
    public static final String RULE_TEXT = "text";
    public static final String RULE_STATUS = "status";
    public static final String RULE_DEROGABLE = "isDerogable";
    public static final String RULE_HELP_MOTIVATION = "helpTextMotivation";
    public static final String RULE_MOTIVATION = "motivation";
    public static final String THEMATICS_PREFIX = "TS";
    public static final String ADDITIONAL_THEMATICS_PREFIX = "TA";
    public static final String RULES_NB_SUFFIX = "-ruleNumber";
    public static final String HANDLE_RULES_RIGHT = "ODF_Rights_Rules_Handle";
    public static final String SPECIFIC_RULE_VIEW = "specific-rules";
    public static final String COMPLEMENTARY_RULE_VIEW = "thematics-edition";
    protected AmetysObjectResolver _resolver;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected PilotageHelper _pilotageHelper;
    protected ThematicsHelper _thematicsHelper;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    protected MCCWorkflowHelper _mccWorkflowHelper;
    protected CopyContentComponent _copyContentComponent;
    protected ContentTypeExtensionPoint _cTypeEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._pilotageHelper = (PilotageHelper)((Object)manager.lookup(PilotageHelper.ROLE));
        this._thematicsHelper = (ThematicsHelper)manager.lookup(ThematicsHelper.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._mccWorkflowHelper = (MCCWorkflowHelper)((Object)manager.lookup(MCCWorkflowHelper.ROLE));
        this._copyContentComponent = (CopyContentComponent)manager.lookup(CopyContentComponent.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public static boolean isRulesEnabled() {
        return (Boolean)Config.getInstance().getValue("odf.pilotage.rules.enabled", false, (Object)false);
    }

    public boolean isRulesModificationAvailable(Container container) {
        if (this._mccWorkflowHelper.isMCCCFVUValidated(container)) {
            return this._rightManager.currentUserHasRight("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW;
        }
        if (this._mccWorkflowHelper.isMCCOrgunitValidated(container)) {
            return this._rightManager.currentUserHasRight("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW;
        }
        if (this._mccWorkflowHelper.isRulesValidated(container)) {
            return this._rightManager.currentUserHasRight("ODF_Pilotage_MCC_CFVU_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("ODF_Pilotage_MCC_Orgunit_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("ODF_Pilotage_Rules_Validated_Super_Rights", (Object)container) == RightManager.RightResult.RIGHT_ALLOW;
        }
        return true;
    }

    @Callable(rights={"__READ_ACCESS"}, rightContext="right.assignment.context.content", paramIndex=0)
    public Map<String, Object> isMccCompatible(String containerId) {
        Container container = (Container)this._resolver.resolveById(containerId);
        if (!this.hasHandleRulesRight(container)) {
            return Map.of("error", "no-right");
        }
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            return Map.of("error", "no-year");
        }
        return Map.of();
    }

    public boolean hasHandleRulesRight(Container container) {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        RightManager.RightResult hasRight = this._rightManager.hasRight(currentUser, HANDLE_RULES_RIGHT, (Object)container);
        return hasRight == RightManager.RightResult.RIGHT_ALLOW;
    }

    private void _checkContainer(Container container) {
        if (!this._pilotageHelper.isContainerOfTypeYear(container)) {
            throw new IllegalArgumentException("The container with id '" + container.getId() + "' must be of nature 'annee'");
        }
    }

    private void _checkStatus(Container container) {
        if (!this.isRulesModificationAvailable(container)) {
            throw new IllegalArgumentException("MCC status of container with id '" + container.getId() + "' does not allow to edit rules");
        }
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> addAdditionalRule(String containerId, String thematicCode, Object text, Object motivation) {
        return this._addAdditionalRule(containerId, thematicCode, text, motivation, 2);
    }

    protected Map<String, Object> _addAdditionalRule(String containerId, String thematicCode, Object text, Object motivation, int actionId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            Container container = (Container)this._resolver.resolveById(containerId);
            this._checkContainer(container);
            this._checkStatus(container);
            String ruleCode = thematicCode + "-A" + this._getUniqueRuleNumber((WorkflowAwareContent)container, thematicCode);
            HashMap<String, Object> repeaterValues = new HashMap<String, Object>();
            repeaterValues.put(RULE_THEMATIC_CODE, thematicCode);
            repeaterValues.put("code", ruleCode);
            repeaterValues.put(RULE_TEXT, this._object2RichText(container, "rules/text", text));
            repeaterValues.put(RULE_MOTIVATION, this._object2RichText(container, "rules/motivation", motivation));
            Map<String, SynchronizableRepeater> values = Map.of("rules", SynchronizableRepeater.appendOrRemove(List.of(repeaterValues), Set.of()));
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)container, values, actionId);
            results.put("ruleId", ruleCode);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred adding additional rule for container '{}'", (Object)containerId, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> editAdditionalRule(String containerId, String ruleCode, String text, String motivation) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            Container container = (Container)this._resolver.resolveById(containerId);
            this._checkContainer(container);
            this._checkStatus(container);
            Optional<? extends ModifiableIndexableRepeaterEntry> ruleEntry = this._getRuleEntry((Content)container, "rules", ruleCode);
            if (ruleEntry.isPresent()) {
                HashMap<String, RichText> repeaterValues = new HashMap<String, RichText>();
                repeaterValues.put(RULE_TEXT, this._object2RichText(container, "rules/text", text));
                repeaterValues.put(RULE_MOTIVATION, this._object2RichText(container, "rules/motivation", motivation));
                Map<String, SynchronizableRepeater> values = Map.of("rules", SynchronizableRepeater.replace(List.of(repeaterValues), List.of(Integer.valueOf(ruleEntry.get().getPosition()))));
                this._contentWorkflowHelper.editContent((WorkflowAwareContent)container, values, 2);
                results.put("ruleId", ruleCode);
            } else {
                this.getLogger().warn("Can't find the additional rule with code '{}' for container '{}'", (Object)ruleCode, (Object)containerId);
                results.put("error", "not-exist");
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred editing additional rule with code '{}' for container '{}'", new Object[]{ruleCode, containerId, e});
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> deleteRule(String containerId, String ruleCode) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(containerId);
        this._checkContainer(container);
        this._checkStatus(container);
        Optional<? extends ModifiableIndexableRepeaterEntry> ruleEntry = this._getRuleEntry((Content)container, "rules", ruleCode);
        if (ruleEntry.isPresent()) {
            ModifiableIndexableRepeaterEntry entry = ruleEntry.get();
            String thematicCode = (String)entry.getValue(RULE_THEMATIC_CODE);
            boolean success = this.deleteRules(container, Set.of(Integer.valueOf(ruleEntry.get().getPosition())));
            results.put("thematicId", thematicCode);
            if (!success) {
                results.put("error", true);
            }
        } else {
            this.getLogger().warn("Can't find the additional rule with code '{}' for container '{}'", (Object)ruleCode, (Object)containerId);
            results.put("error", "not-exist");
        }
        return results;
    }

    public boolean deleteRules(Container container, Set<Integer> rulePositions) {
        if (rulePositions.isEmpty()) {
            return true;
        }
        boolean success = false;
        try {
            Map<String, SynchronizableRepeater> values = Map.of("rules", SynchronizableRepeater.appendOrRemove(List.of(), rulePositions));
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)container, values, 2);
            success = true;
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred deleting rules for content '{}'", (Object)container.getId(), (Object)e);
        }
        return success;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> getRuleValues(String containerId, String ruleCode) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(containerId);
        this._checkContainer(container);
        Optional<? extends ModifiableIndexableRepeaterEntry> ruleEntry = this._getRuleEntry((Content)container, "rules", ruleCode);
        if (ruleEntry.isPresent()) {
            ModifiableIndexableRepeaterEntry entry = ruleEntry.get();
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(RULE_TEXT, this._getRichTextToJSONForEdition((Content)container, entry, "rules", RULE_TEXT));
            values.put(RULE_MOTIVATION, this._getRichTextToJSONForEdition((Content)container, entry, "rules", RULE_MOTIVATION));
            results.put("values", values);
        }
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> getRuleInfo(String containerId, String thematicCode, String ruleCode) {
        Optional<? extends ModifiableIndexableRepeaterEntry> derogatedRuleEntry;
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(containerId);
        this._checkContainer(container);
        Content thematic = this._thematicsHelper.getThematic(container.getCatalog(), thematicCode);
        if (thematic == null) {
            results.put("error", true);
            return results;
        }
        Optional<? extends ModifiableIndexableRepeaterEntry> ruleEntry = this._getRuleEntry(thematic, "rules", ruleCode);
        if (ruleEntry.isPresent()) {
            ModifiableIndexableRepeaterEntry entry = ruleEntry.get();
            results.put(RULE_TEXT, this._getRichTextToJSONForEdition(thematic, entry, "rules", RULE_TEXT));
            results.put(RULE_HELP_TEXT, this._getRichTextToJSONForEdition(thematic, entry, "rules", RULE_HELP_TEXT));
            results.put(RULE_HELP_MOTIVATION, this._getRichTextToJSONForEdition(thematic, entry, "rules", RULE_HELP_MOTIVATION));
        }
        if ((derogatedRuleEntry = this._getRuleEntry((Content)container, "rules", ruleCode)).isPresent()) {
            results.put("derogationText", this._getRichTextToJSONForEdition((Content)container, derogatedRuleEntry.get(), "rules", RULE_TEXT));
            results.put("derogationMotivation", this._getRichTextToJSONForEdition((Content)container, derogatedRuleEntry.get(), "rules", RULE_MOTIVATION));
        }
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> derogateRule(String containerId, String thematicCode, String ruleCode, Object text, Object motivation) {
        return this._derogateRule(containerId, thematicCode, ruleCode, text, motivation, 2);
    }

    protected Map<String, Object> _derogateRule(String containerId, String thematicCode, String ruleCode, Object text, Object motivation, int actionId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            Container container = (Container)this._resolver.resolveById(containerId);
            this._checkContainer(container);
            this._checkStatus(container);
            Set entryToRemove = this._getRuleEntry((Content)container, "rules", ruleCode).map(RepeaterEntry::getPosition).map(Set::of).orElseGet(Set::of);
            HashMap<String, String> repeaterValues = new HashMap<String, String>();
            repeaterValues.put("code", ruleCode);
            repeaterValues.put(RULE_TEXT, (String)this._object2RichText(container, "rules/text", text));
            repeaterValues.put(RULE_MOTIVATION, (String)this._object2RichText(container, "rules/motivation", motivation));
            Map<String, SynchronizableRepeater> values = Map.of("rules", SynchronizableRepeater.appendOrRemove(List.of(repeaterValues), (Set)entryToRemove));
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)container, values, actionId);
            results.put("ruleId", ruleCode);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred derogating rule for content '{}'", (Object)containerId, (Object)e);
            results.put("error", true);
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> getAllowedContainers(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String containerId = (String)params.get("containerId");
        Container currentContainer = (Container)this._resolver.resolveById(containerId);
        String catalog = currentContainer.getCatalog();
        String ruleCode = (String)params.get("ruleId");
        Predicate<Container> canEditRulesPredicate = c -> this.isRulesModificationAvailable((Container)c);
        Predicate<Container> rightPredicate = c -> this.hasHandleRulesRight((Container)c);
        Predicate<Container> notItSelfPredicate = c -> !c.getId().equals(containerId);
        Stream<Container> containers = StringUtils.isEmpty((CharSequence)ruleCode) ? this._thematicsHelper.getSimilarContainers(currentContainer, List.of(rightPredicate, notItSelfPredicate, canEditRulesPredicate)) : this._thematicsHelper.getCompatibleContainers(this._thematicsHelper.getThematic(catalog, this._thematicsHelper.getThematicCode(ruleCode)), List.of(rightPredicate, notItSelfPredicate, canEditRulesPredicate));
        List<Map> containersInfo = containers.map(c -> Map.of("id", c.getId(), "code", c.getCode(), "title", c.getTitle(), "isDerogated", ArrayUtils.contains((Object[])((Object[])c.getValue("rules/code", true)), (Object)ruleCode), "hasComplementaryRules", c.hasValue(CONTAINER_THEMATICS))).toList();
        result.put("containers", containersInfo);
        return result;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> copyRule(String srcContainerId, String thematicCode, String ruleCode, List<String> destContainerIds) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(srcContainerId);
        this._checkContainer(container);
        Optional<? extends ModifiableIndexableRepeaterEntry> entry = this._getRuleEntry((Content)container, "rules", ruleCode);
        ArrayList<Map<String, String>> containersInError = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> updatedContainers = new ArrayList<Map<String, String>>();
        if (entry.isPresent()) {
            ModifiableIndexableRepeaterEntry ruleEntry = entry.get();
            Object text = ruleEntry.getValue(RULE_TEXT);
            Object motivation = ruleEntry.getValue(RULE_MOTIVATION);
            boolean isDerogated = this._isDerogatedRule((ModifiableModelAwareRepeaterEntry)ruleEntry);
            for (String destContainerId : destContainerIds) {
                Container destContainer = (Container)this._resolver.resolveById(destContainerId);
                boolean isEditionAvailable = this.isRulesModificationAvailable(destContainer);
                boolean hasRight = this.hasHandleRulesRight(destContainer);
                if (isEditionAvailable && hasRight) {
                    Map<Object, Object> res = new HashMap();
                    res = isDerogated ? this._derogateRule(destContainerId, thematicCode, ruleCode, text, motivation, 222) : this._addAdditionalRule(destContainerId, thematicCode, text, motivation, 222);
                    if (res.containsKey("error")) {
                        containersInError.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
                        continue;
                    }
                    updatedContainers.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
                    continue;
                }
                containersInError.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
                if (!hasRight) {
                    this.getLogger().error("Unable to copy rule on container '{}' because user has no sufficient right", (Object)destContainerId);
                    continue;
                }
                this.getLogger().error("Unable to copy rule on container '{}' because MCC status does not allow to edit rules", (Object)destContainerId);
            }
        } else {
            this.getLogger().error("No rule exists with id '{}' for container '{}'", (Object)ruleCode, (Object)srcContainerId);
            results.put("error", "not-exist");
        }
        if (!containersInError.isEmpty()) {
            results.put("size", destContainerIds.size());
            results.put("error-containers", containersInError);
        }
        results.put("updated-containers", updatedContainers);
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> copyAllRules(String srcContainerId, List<String> destContainerIds) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(srcContainerId);
        this._checkContainer(container);
        Map thematics = this._thematicsHelper.getThematics(container.getCatalog()).collect(Collectors.toMap(c -> (String)c.getValue("code"), Function.identity()));
        ArrayList<Map<String, String>> containersInError = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> updatedContainers = new ArrayList<Map<String, String>>();
        for (String destContainerId : destContainerIds) {
            Container destContainer = (Container)this._resolver.resolveById(destContainerId);
            boolean isEditionAvailable = this.isRulesModificationAvailable(destContainer);
            boolean hasRight = this.hasHandleRulesRight(destContainer);
            if (isEditionAvailable && hasRight) {
                HashMap<String, Boolean> thematicCompatibility = new HashMap<String, Boolean>();
                ArrayList destRepeaterValues = new ArrayList();
                HashSet entryToRemove = new HashSet();
                ModifiableIndexableRepeater repeater = container.getRepeater("rules");
                if (repeater != null) {
                    for (ModifiableModelAwareRepeaterEntry rule : repeater.getEntries()) {
                        Content thematic;
                        String ruleCode = (String)rule.getValue("code");
                        String thematicCode = this._thematicsHelper.getThematicCode(ruleCode);
                        if (!thematicCompatibility.computeIfAbsent(thematicCode, arg_0 -> this.lambda$copyAllRules$5(destContainer, thematic = (Content)thematics.get(thematicCode), arg_0)).booleanValue()) continue;
                        HashMap<String, Object> repeaterValues = new HashMap<String, Object>();
                        repeaterValues.put(RULE_TEXT, rule.getValue(RULE_TEXT));
                        repeaterValues.put(RULE_MOTIVATION, rule.getValue(RULE_MOTIVATION));
                        if (this._isDerogatedRule(rule)) {
                            entryToRemove.addAll(this._getRuleEntry((Content)destContainer, "rules", ruleCode).map(e -> Set.of(Integer.valueOf(e.getPosition()))).orElse(Set.of()));
                            repeaterValues.put("code", ruleCode);
                        } else {
                            String newRuleCode = thematicCode + "-A" + this._getUniqueRuleNumber((WorkflowAwareContent)destContainer, thematicCode);
                            repeaterValues.put("code", newRuleCode);
                            repeaterValues.put(RULE_THEMATIC_CODE, rule.getValue(RULE_THEMATIC_CODE));
                        }
                        destRepeaterValues.add(repeaterValues);
                    }
                }
                HashMap<String, SynchronizableRepeater> values = new HashMap<String, SynchronizableRepeater>();
                values.put("rules", SynchronizableRepeater.appendOrRemove(destRepeaterValues, entryToRemove));
                ContentType containerCType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.odf.Content.container");
                View complementaryRules = containerCType.getView(COMPLEMENTARY_RULE_VIEW);
                values.putAll(container.dataToMap((ViewItemAccessor)complementaryRules));
                View specificRules = containerCType.getView(SPECIFIC_RULE_VIEW);
                if (specificRules != null) {
                    values.putAll(container.dataToMap((ViewItemAccessor)specificRules));
                }
                try {
                    this._contentWorkflowHelper.editContent((WorkflowAwareContent)destContainer, values, 222);
                    updatedContainers.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
                }
                catch (Exception e2) {
                    containersInError.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
                    this.getLogger().error("An error occurred copying rules for content '{}'", (Object)destContainerId, (Object)e2);
                }
                continue;
            }
            containersInError.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
            if (!hasRight) {
                this.getLogger().error("Unable to copy rule on container '{}' because user has no sufficient right", (Object)destContainerId);
                continue;
            }
            this.getLogger().error("Unable to copy rule on container '{}' because MCC status does not allow to edit rules", (Object)destContainerId);
        }
        if (!containersInError.isEmpty()) {
            results.put("size", destContainerIds.size());
            results.put("error-containers", containersInError);
        }
        results.put("updated-containers", updatedContainers);
        return results;
    }

    @Callable(rights={"ODF_Rights_Rules_Handle"}, paramIndex=0, rightContext="right.assignment.context.content")
    public Map<String, Object> copyRulesFromView(String srcContainerId, List<String> destContainerIds, String viewName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Container container = (Container)this._resolver.resolveById(srcContainerId);
        this._checkContainer(container);
        ArrayList<Map<String, String>> containersInError = new ArrayList<Map<String, String>>();
        ArrayList updatedContainers = new ArrayList();
        for (String destContainerId : destContainerIds) {
            Container destContainer = (Container)this._resolver.resolveById(destContainerId);
            boolean isEditionAvailable = this.isRulesModificationAvailable(destContainer);
            boolean hasRight = this.hasHandleRulesRight(destContainer);
            if (isEditionAvailable && hasRight) {
                this._copyContentComponent.editContent(srcContainerId, destContainerId, Map.of(), viewName, null);
                continue;
            }
            if (!hasRight) {
                this.getLogger().error("Unable to copy rules from view '{}' on container '{}' because user has no sufficient right", (Object)viewName, (Object)destContainerId);
            } else {
                this.getLogger().error("Unable to copy rules from view '{}' on container '{}' because MCC status does not allow to edit rules", (Object)viewName, (Object)destContainerId);
            }
            containersInError.add(Map.of("id", destContainerId, "title", destContainer.getTitle(), "code", destContainer.getCode()));
        }
        if (!containersInError.isEmpty()) {
            results.put("size", destContainerIds.size());
            results.put("error-containers", containersInError);
        }
        results.put("updated-containers", updatedContainers);
        return results;
    }

    private boolean _isDerogatedRule(ModifiableModelAwareRepeaterEntry entry) {
        return !entry.hasValue(RULE_THEMATIC_CODE);
    }

    private Optional<? extends ModifiableIndexableRepeaterEntry> _getRuleEntry(Content content, String repeaterName, String ruleCode) {
        return Optional.ofNullable(content).map(c -> (ModifiableIndexableRepeater)c.getValue(repeaterName)).map(ModifiableIndexableRepeater::getEntries).map(Collection::stream).orElseGet(() -> Stream.of(new ModifiableIndexableRepeaterEntry[0])).filter(e -> ruleCode.equals(e.getValue("code"))).findAny();
    }

    private Long _getUniqueRuleNumber(WorkflowAwareContent content, String thematicCode) {
        Long ruleNumber;
        Long l = ruleNumber = (Long)content.getInternalDataHolder().getValue(thematicCode + RULES_NB_SUFFIX, (Object)0L);
        ruleNumber = ruleNumber + 1L;
        content.getInternalDataHolder().setValue(thematicCode + RULES_NB_SUFFIX, (Object)ruleNumber);
        content.saveChanges();
        return ruleNumber;
    }

    private Object _getRichTextToJSONForEdition(Content content, ModifiableIndexableRepeaterEntry entry, String repeaterName, String attributeName) {
        String dataPath = repeaterName + "[" + entry.getPosition() + "]/" + attributeName;
        DataContext context = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)content).withDataPath(dataPath);
        ModelItemType type = entry.getType(attributeName);
        return type.valueToJSONForEdition(entry.getValue(attributeName), context);
    }

    private RichText _object2RichText(Container container, String path, Object richTextObject) {
        if (richTextObject instanceof RichText) {
            RichText richText = (RichText)richTextObject;
            return richText;
        }
        if (richTextObject instanceof String) {
            String richTextAsString = (String)richTextObject;
            ElementDefinition definition = (ElementDefinition)container.getDefinition(path);
            ElementType type = definition.getType();
            DataContext withModelItem = RepositoryDataContext.newInstance().withObject((DataAwareAmetysObject)container).withModelItem((ModelItem)definition);
            return (RichText)type.fromJSONForClient((Object)richTextAsString, withModelItem);
        }
        return null;
    }

    private /* synthetic */ Boolean lambda$copyAllRules$5(Container destContainer, Content thematic, String __) {
        return this._thematicsHelper.areCompatible(destContainer, thematic);
    }
}

