/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfpilotage.rule.export;

import java.io.IOException;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.odfpilotage.rule.AbstractThematicsGenerator;
import org.ametys.plugins.odfpilotage.rule.enumerators.NbSessionsEnumerator;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ThematicsExportGenerator
extends AbstractThematicsGenerator
implements Initializable {
    private String _odfLang;

    public void initialize() throws Exception {
        this._odfLang = (String)Config.getInstance().getValue("odf.programs.lang");
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"export");
        if (this._thematicsHelper.hasHandleThematicRight()) {
            this._saxFilters();
            this._saxContents();
            this._saxGroups();
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"export");
        this.contentHandler.endDocument();
    }

    private void _saxContents() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"contents");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String catalog = request.getParameter("catalog");
        String degreeId = request.getParameter("degree");
        for (Content thematic : this._thematicsHelper.getCompatibleThematics(catalog, degreeId)) {
            this._saxContent(thematic);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"contents");
    }

    protected void _saxFilters() throws SAXException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String catalog = request.getParameter("catalog");
        String degreeId = request.getParameter("degree");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"filters");
        this._saxCatalog(catalog);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("value", degreeId);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"degree", (Attributes)attrs, (String)this._odfRefTableHelper.getItemLabel(degreeId, this._odfLang));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"filters");
    }

    protected void _saxGroups() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"groups");
        this._saxEnumerator(new NbSessionsEnumerator(), "nbSessions");
        this._odfRefTableHelper.saxItems(this.contentHandler, "odf-enumeration.MccRegime");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"groups");
    }

    protected void _saxEnumerator(Enumerator<String> enumerator, String tagName) throws SAXException {
        try {
            Map entries = enumerator.getTypedEntries();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)tagName);
            for (String key : entries.keySet()) {
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("key", key);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry", (Attributes)attrs);
                ((I18nizableText)entries.get(key)).toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)tagName);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                SAXException se = (SAXException)e;
                throw se;
            }
            throw new SAXException("Error while resolving enumerator entries " + enumerator.getClass().getName(), e);
        }
    }
}

